/*!
 * Web Cabin Docker - Docking Layout Interface.
 *
 * Dependancies:
 *  JQuery 1.11.1
 *  JQuery-contextMenu 1.6.6
 *  font-awesome 4.2.0
 *
 * Author: Jeff Houde (lochemage@webcabin.org)
 * Web: http://docker.webcabin.org/
 *
 * Licensed under
 *   MIT License http://www.opensource.org/licenses/mit-license
 *   GPL v3 http://opensource.org/licenses/GPL-3.0
 *
 */
function wcDocker(e,t){
	this.$outer=$(e),this.$container=$('<div class="wcDocker">'),this.$transition=$('<div class="wcDockerTransition">'),this.$outer.append(this.$container),this.$container.append(this.$transition),this._canOrientTabs=!0,this._events={},this._root=null,this._frameList=[],this._floatingList=[],this._modalList=[],this._focusFrame=null,this._placeholderPanel=null,this._contextTimer=0,this._dirty=!1,this._splitterList=[],this._tabList=[],this._collapser={},this._dockPanelTypeList=[],this._creatingPanel=!1,this._draggingSplitter=null,this._draggingFrame=null,this._draggingFrameSizer=null,this._draggingFrameTab=null,this._draggingFrameTopper=!1,this._draggingCustomTabFrame=null,this._ghost=null,this._menuTimer=0,this._mouseOrigin={x:0,y:0},this._resizeData={time:-1,timeout:!1,delta:150};var n={themePath:"Themes",theme:"default",allowContextMenu:!0,hideOnResize:!1,allowCollapse:!0,responseRate:10};this._options={};for(var r in n)this._options[r]=n[r];for(var r in t)this._options[r]=t[r];this.__init()}function wcGhost(e,t,n){this.$ghost=null,this._rect,this._anchorMouse=!1,this._anchor=null,this._docker=n,this.__init(e,t)}function wcLayout(e,t){this.$container=$(e),this._parent=t,this._batchProcess=!1,this._grid=[],this.$table=null,this.__init()}function wcPanel(e,t){this.$container=null,this._parent=null,this.$icon=null,this.$title=null,this.$titleText=null,this._panelObject=null,this._initialized=!1,this._type=e,this._title=e,this._titleVisible=!0,this._options=t,this._layout=null,this._buttonList=[],this._actualPos={x:.5,y:.5},this._actualSize={x:0,y:0},this._resizeData={time:-1,timeout:!1,delta:150},this._pos={x:.5,y:.5},this._moveData={time:-1,timeout:!1,delta:150},this._size={x:-1,y:-1},this._minSize={x:100,y:100},this._maxSize={x:Infinity,y:Infinity},this._scroll={x:0,y:0},this._scrollable={x:!0,y:!0},this._collapsible=!0,this._overflowVisible=!1,this._moveable=!0,this._closeable=!0,this._resizeVisible=!0,this._isVisible=!1,this._events={},this.__init()}function wcFrame(e,t,n){this.$container=$(e),this._parent=t,this._isFloating=n,this.$frame=null,this.$title=null,this.$titleBar=null,this.$tabBar=null,this.$tabScroll=null,this.$center=null,this.$tabLeft=null,this.$tabRight=null,this.$close=null,this.$collapse=null,this.$top=null,this.$bottom=null,this.$left=null,this.$right=null,this.$corner1=null,this.$corner2=null,this.$corner3=null,this.$corner4=null,this.$buttonBar=null,this.$shadower=null,this.$modalBlocker=null,this._titleVisible=!0,this._canScrollTabs=!1,this._tabOrientation=wcDocker.TAB.TOP,this._tabScrollPos=0,this._curTab=-1,this._panelList=[],this._buttonList=[],this._resizeData={time:-1,timeout:!1,delta:150},this._pos={x:.5,y:.5},this._size={x:400,y:400},this._lastSize={x:400,y:400},this._anchorMouse={x:0,y:0},this.__init()}function wcSplitter(e,t,n){this.$container=$(e),this._parent=t,this._orientation=n,this._pane=[!1,!1],this.$pane=[],this.$bar=null,this._pos=.5,this._posTarget=.5,this._pixelPos=-1,this._findBestPos=!1,this._anim=0,this._boundEvents=[],this.__init(),this.docker()._splitterList.push(this)}function wcCollapser(e,t,n){this.$container=$(e),this.$frame=null,this._position=n,this._parent=t,this._splitter=null,this._drawer=null,this._size=0,this._orientation=this._position===wcDocker.DOCK.LEFT||this._position===wcDocker.DOCK.RIGHT?wcDocker.ORIENTATION.HORIZONTAL:wcDocker.ORIENTATION.VERTICAL,this.__init()}function wcDrawer(e,t,n){this.$container=$(e),this.$frame=null,this._position=n,this._parent=t,this._frame=null,this._closeSize=0,this._expanded=!1,this._sliding=!1,this._orientation=this._position===wcDocker.DOCK.LEFT||this._position===wcDocker.DOCK.RIGHT?wcDocker.ORIENTATION.HORIZONTAL:wcDocker.ORIENTATION.VERTICAL,this.__init()}function wcTabFrame(e,t){this.$container=$(e),this._parent=t,this.$frame=null,this.$tabBar=null,this.$tabScroll=null,this.$center=null,this.$tabLeft=null,this.$tabRight=null,this.$close=null,this._tabOrientation=wcDocker.TAB.TOP,this._canScrollTabs=!1,this._tabScrollPos=0,this._curTab=-1,this._layoutList=[],this._moveable=!0,this._boundEvents=[],this.__init()}function wcIFrame(e,t){this._panel=t,this._layout=t.layout(),this.$container=$(e),this.$frame=null,this.$focus=null,this.$iFrame=null,this._window=null,this._isAttached=!0,this._hasFocus=!1,this._isDocking=!1,this._isHovering=!1,this._boundEvents=[],this.__init()}wcDocker.DOCK={MODAL:"modal",FLOAT:"float",TOP:"top",LEFT:"left",RIGHT:"right",BOTTOM:"bottom",STACKED:"stacked"},wcDocker.EVENT={INIT:"panelInit",UPDATED:"panelUpdated",VISIBILITY_CHANGED:"panelVisibilityChanged",BEGIN_DOCK:"panelBeginDock",END_DOCK:"panelEndDock",GAIN_FOCUS:"panelGainFocus",LOST_FOCUS:"panelLostFocus",CLOSED:"panelClosed",BUTTON:"panelButton",ATTACHED:"panelAttached",DETACHED:"panelDetached",MOVE_STARTED:"panelMoveStarted",MOVE_ENDED:"panelMoveEnded",MOVED:"panelMoved",RESIZE_STARTED:"panelResizeStarted",RESIZE_ENDED:"panelResizeEnded",RESIZED:"panelResized",SCROLLED:"panelScrolled",SAVE_LAYOUT:"layoutSave",RESTORE_LAYOUT:"layoutRestore",CUSTOM_TAB_CHANGED:"customTabChanged",CUSTOM_TAB_CLOSED:"customTabClosed"},wcDocker.PANEL_PLACEHOLDER="__wcDockerPlaceholderPanel",wcDocker.COLLAPSED="__wcDockerCollapsedPanel",wcDocker.ORIENTATION={VERTICAL:!1,HORIZONTAL:!0},wcDocker.TAB={TOP:"top",LEFT:"left",RIGHT:"right",BOTTOM:"bottom"},wcDocker.prototype={themePath:function(e){return e!==undefined&&(this._options.themePath=e),this._options.themePath},theme:function(e){if(e!==undefined){var t=$("#wcTheme"),n=(new Date).getTime(),r=e.indexOf(".css");r>-1&&(e=e.substring(0,r));var i=$('<link id="wcTheme" rel="stylesheet" type="text/css" href="'+this._options.themePath+"/"+e+".css?v="+n+'"/>');this._options.theme=e;var s=this;i[0].onload=function(){t.remove(),s.__update()},$("head").append(i)}return this._options.theme},isCollapseEnabled:function(){return this._canOrientTabs&&this._options.allowCollapse},registerPanelType:function(e,t,n){var r=t;typeof r=="function"&&(r={onCreate:t},console.log("WARNING: Passing in the creation function directly to wcDocker.registerPanelType parameter 2 is now deprecated and will be removed in the next version!  Please use the preferred options object instead.")),typeof n!="undefined"&&(r.isPrivate=n,console.log("WARNING: Passing in the isPrivate flag to wcDocker.registerPanelType parameter 3 is now deprecated and will be removed in the next version!  Please use the preferred options object instead.")),$.isEmptyObject(r)&&(r=null);for(var i=0;i<this._dockPanelTypeList.length;++i)if(this._dockPanelTypeList[i].name===e)return!1;this._dockPanelTypeList.push({name:e,options:r});var s=$("menu").find("menu");return s.append($('<menuitem label="'+e+'">')),!0},panelTypes:function(e){var t=[];for(var n=0;n<this._dockPanelTypeList.length;++n)(e||!this._dockPanelTypeList[n].options.isPrivate)&&t.push(this._dockPanelTypeList[n].name);return t},panelTypeInfo:function(e){for(var t=0;t<this._dockPanelTypeList.length;++t)if(this._dockPanelTypeList[t].name==e)return this._dockPanelTypeList[t].options;return!1},addPanel:function(e,t,n,r){for(var i=0;i<this._dockPanelTypeList.length;++i)if(this._dockPanelTypeList[i].name===e){var s=this._dockPanelTypeList[i],o=new wcPanel(e,s.options);o._parent=this,o.__container(this.$transition);var u=s.options&&s.options.options||{};return o._panelObject=new s.options.onCreate(o,u),t===wcDocker.DOCK.STACKED?this.__addPanelGrouped(o,n,r):this.__addPanelAlone(o,t,n,r),this._placeholderPanel&&o.moveable()&&t!==wcDocker.DOCK.FLOAT&&t!==wcDocker.DOCK.MODAL&&this.removePanel(this._placeholderPanel)&&(this._placeholderPanel=null),this.__forceUpdate(),o}return!1},removePanel:function(e){if(!e)return!1;var t=this.__isLastPanel(e),n=e._parent;if(n instanceof wcFrame){e.__trigger(wcDocker.EVENT.CLOSED);if(!n.removePanel(e)&&!n.isCollapser()){if(t)return this.__addPlaceholder(n),!0;var r=this._floatingList.indexOf(n);r!==-1&&this._floatingList.splice(r,1),r=this._frameList.indexOf(n),r!==-1&&this._frameList.splice(r,1),r=this._modalList.indexOf(n),r!==-1&&this._modalList.splice(r,1),this._modalList.length?this.__focus(this._modalList[this._modalList.length-1]):this._floatingList.length&&this.__focus(this._floatingList[this._floatingList.length-1]);var i=n._parent;if(i instanceof wcSplitter){i.__removeChild(n);var s;i.pane(0)?(s=i.pane(0),i._pane[0]=null):(s=i.pane(1),i._pane[1]=null),s.__container(this.$transition),s._parent=null,r=this._splitterList.indexOf(i),r!==-1&&this._splitterList.splice(r,1);var o=i._parent;parentContainer=i.__container(),i.__destroy(),o instanceof wcSplitter?(o.__removeChild(i),o.pane(0)?o.pane(1,s):o.pane(0,s)):o===this&&(this._root=s,s._parent=this,s.__container(parentContainer)),this.__update()}else n===this._root&&(this._root=null);this._focusFrame===n&&(this._focusFrame=null),n.__destroy()}return e.__destroy(),!0}return!1},movePanel:function(e,t,n,r){var i=this.__isLastPanel(e),s=e.$container;e._parent instanceof wcFrame&&(s=e._parent.$frame);var o=s.offset(),u=s.width(),a=s.height(),f=e._parent,l=!1;if(f instanceof wcFrame){l=f._isFloating;for(var c=0;c<f._panelList.length;++c)if(f._panelList[c]===e){f.isCollapser()?f._curTab=-1:f._curTab>=c&&f._curTab--,e.__container(this.$transition),e._parent=null,f._panelList.splice(c,1);break}!f.isCollapser()&&f._curTab===-1&&f._panelList.length&&(f._curTab=0),f.__updateTabs(),f.collapse();if(!f.isCollapser()&&f._panelList.length===0)if(i)this.__addPlaceholder(f);else{var h=this._floatingList.indexOf(f);h!==-1&&this._floatingList.splice(h,1),h=this._frameList.indexOf(f),h!==-1&&this._frameList.splice(h,1);var p=f._parent;if(p instanceof wcSplitter){p.__removeChild(f);var d;p.pane(0)?(d=p.pane(0),p._pane[0]=null):(d=p.pane(1),p._pane[1]=null),d.__container(this.$transition),d._parent=null,h=this._splitterList.indexOf(p),h!==-1&&this._splitterList.splice(h,1);var v=p._parent;parentContainer=p.__container(),p.__destroy(),v instanceof wcSplitter?(v.__removeChild(p),v.pane(0)?v.pane(1,d):v.pane(0,d)):v===this&&(this._root=d,d._parent=this,d.__container(parentContainer)),this.__update()}this._focusFrame===f&&(this._focusFrame=null),f.__destroy()}}e.initSize(u,a),t===wcDocker.DOCK.STACKED?this.__addPanelGrouped(e,n,r):this.__addPanelAlone(e,t,n,r),n==this._placeholderPanel&&(this.removePanel(this._placeholderPanel),this._placeholderPanel=null);var m=e._parent;return m instanceof wcFrame&&m._panelList.length===1&&m.pos(o.left+u/2+20,o.top+a/2+20,!0),this.__update(!0),m instanceof wcFrame&&l!==m._isFloating&&(m._isFloating?e.__trigger(wcDocker.EVENT.DETACHED):e.__trigger(wcDocker.EVENT.ATTACHED)),e.__trigger(wcDocker.EVENT.MOVED),e},findPanels:function(e){var t=[];for(var n=0;n<this._frameList.length;++n){var r=this._frameList[n];for(var i=0;i<r._panelList.length;++i){var s=r._panelList[i];(!e||s._type===e)&&t.push(s)}}return t},on:function(e,t){return e?(this._events[e]||(this._events[e]=[]),this._events[e].indexOf(t)!==-1?!1:(this._events[e].push(t),!0)):!1},off:function(e,t){if(typeof e=="undefined"){this._events={};return}if(this._events[e])if(typeof t=="undefined")this._events[e]=[];else for(var n=0;n<this._events[e].length;++n)if(this._events[e][n]===t){this._events[e].splice(n,1);break}},trigger:function(e,t){if(!e)return!1;for(var n=0;n<this._frameList.length;++n){var r=this._frameList[n];for(var i=0;i<r._panelList.length;++i){var s=r._panelList[i];s.__trigger(e,t)}}this.__trigger(e,t)},basicMenu:function(e,t,n){console.log("WARNING: wcDocker.basicMenu is deprecated, please use wcDocker.menu instead."),this.menu(e,t,n)},menu:function(e,t,n){var r=this;$.contextMenu({selector:e,build:function(e,i){var s=r.__mouse(i),o;for(var u=0;u<r._frameList.length;++u){var a=e.hasClass("wcFrame")&&e||e.parents(".wcFrame");if(r._frameList[u].$frame[0]===a[0]){o=r._frameList[u];break}}var f=!1;$(i.target).hasClass("wcTabScroller")&&(f=!0);var l={};for(var u=0;u<r._dockPanelTypeList.length;++u){var c=r._dockPanelTypeList[u];if(!c.options.isPrivate){if(c.options.limit>0&&r.findPanels(c.name).length>=c.options.limit)continue;var h=null,p=null,d=c.name;c.options&&(c.options.faicon&&(p=c.options.faicon),c.options.icon&&(h=c.options.icon),c.options.title&&(d=c.options.title)),l[c.name]={name:d,icon:h,faicon:p,className:"wcMenuCreatePanel"}}}var v=0,m={},g=t;typeof t=="function"&&(g=t(e,i));for(var u=0;u<g.length;++u){if($.isEmptyObject(g[u])){m["sep"+v++]="---------";continue}var y=g[u].callback;y&&function(e,t){e.callback=function(e,n){var i=null,s=n.$trigger.parents(".wcFrame").first();if(s.length)for(var o=0;o<r._frameList.length;++o)s[0]===r._frameList[o].$frame[0]&&(i=r._frameList[o].panel());t(e,n,i)}}(g[u],y),m[g[u].name]=g[u]}var b={},w="";if(r.isCollapseEnabled()){var E=o.$collapse.children("div");E.hasClass("wcCollapseLeft")?w=" wcCollapseLeft":E.hasClass("wcCollapseRight")?w=" wcCollapseRight":w=" wcCollapseBottom",b[wcDocker.DOCK.LEFT]={name:wcDocker.DOCK.LEFT,faicon:"sign-in wcCollapseLeft wcCollapsible"},b[wcDocker.DOCK.RIGHT]={name:wcDocker.DOCK.RIGHT,faicon:"sign-in wcCollapseRight wcCollapsible"},b[wcDocker.DOCK.BOTTOM]={name:wcDocker.DOCK.BOTTOM,faicon:"sign-in wcCollapseBottom wcCollapsible"}}var S=m;if(n){$.isEmptyObject(m)||(S["sep"+v++]="---------"),f?(S["Close Panel"]={name:"Remove Panel",faicon:"close",disabled:!o.panel().closeable()},r.isCollapseEnabled()&&(o.isCollapser()?S["Attach Panel"]={name:"Dock Panel",faicon:"sign-out"+w+" wcCollapsed"}:S.fold1={name:"Collapse Panel",faicon:"sign-in"+w+" wcCollapsible",items:b}),o._isFloating||(S["Detach Panel"]={name:"Float Panel",faicon:"level-up",disabled:!o.panel().moveable()||o.panel()._isPlaceholder}),S["sep"+v++]="---------",S.fold2={name:"Add Panel",faicon:"columns",items:l,disabled:!o.panel()._titleVisible||!!o._isFloating&&r._modalList.indexOf(o)!==-1,className:"wcMenuCreatePanel"}):(o&&(S["Close Panel"]={name:"Remove Panel",faicon:"close",disabled:!o.panel().closeable()},r.isCollapseEnabled()&&(o.isCollapser()?S["Attach Panel"]={name:"Dock Panel",faicon:"sign-out"+w+" wcCollapsed"}:S.fold1={name:"Collapse Panel",faicon:"sign-in"+w+" wcCollapsible",items:b}),o._isFloating||(S["Detach Panel"]={name:"Float Panel",faicon:"level-up",disabled:!o.panel().moveable()||o.panel()._isPlaceholder}),S["sep"+v++]="---------"),S.fold2={name:"Add Panel",faicon:"columns",items:l,disabled:!(!o||!o._isFloating&&o.panel().moveable()),className:"wcMenuCreatePanel"});if(o&&!o._isFloating&&o.panel().moveable()){var x=o.__rect();r._ghost=new wcGhost(x,s,r),o.__checkAnchorDrop(s,!1,r._ghost,!0,!1),r._ghost.$ghost.hide()}}return{callback:function(e,t){if(e==="Close Panel")setTimeout(function(){o.panel().close()},10);else if(e==="Detach Panel")r.movePanel(o.panel(),wcDocker.DOCK.FLOAT,!1);else if(e==="Attach Panel"){var n=o.$collapse.children("div"),i=wcDocker.DOCK.BOTTOM;n.hasClass("wcCollapseLeft")?i=wcDocker.DOCK.LEFT:n.hasClass("wcCollapseRight")&&(i=wcDocker.DOCK.RIGHT);var s={};switch(i){case wcDocker.DOCK.LEFT:s.w=o.$frame.width();break;case wcDocker.DOCK.RIGHT:s.w=o.$frame.width();break;case wcDocker.DOCK.BOTTOM:s.h=o.$frame.height()}var u=r._collapser[wcDocker.DOCK.LEFT]._parent.right();o.collapse(!0),r.movePanel(o.panel(),i,u,s)}else if(e===wcDocker.DOCK.LEFT)r.movePanel(o.panel(),wcDocker.DOCK.LEFT,wcDocker.COLLAPSED);else if(e===wcDocker.DOCK.RIGHT)r.movePanel(o.panel(),wcDocker.DOCK.RIGHT,wcDocker.COLLAPSED);else if(e===wcDocker.DOCK.BOTTOM)r.movePanel(o.panel(),wcDocker.DOCK.BOTTOM,wcDocker.COLLAPSED);else if(r._ghost&&o){var a=r._ghost.anchor(),f=r.addPanel(e,a.loc,o.panel(),r._ghost.rect());f.focus()}},events:{show:function(e){(function(t){var n={},r=e.$menu.find(".context-menu-item");for(var i=0;i<r.length;++i){var s=$(r[i]),o=s.find("span");o.length&&(n[o[0].innerHTML]=s)}(function u(e){for(var t in e){var r=e[t],i=n[r.name];if(i){var s=$('<div class="wcMenuIcon">');i.prepend(s),r.icon&&s.addClass(r.icon),r.faicon&&s.addClass("fa fa-menu fa-"+r.faicon+" fa-lg fa-fw");if(i.hasClass("context-menu-submenu")){var o=$('<div class="wcMenuSubMenu fa fa-caret-right fa-lg">');i.append(o)}}r.items&&u(r.items)}})(t)})(S)},hide:function(e){r._ghost&&(r._ghost.destroy(),r._ghost=!1)}},animation:{duration:250,show:"fadeIn",hide:"fadeOut"},reposition:!1,autoHide:!0,zIndex:200,items:S}}})},bypassMenu:function(){this._menuTimer&&clearTimeout(this._menuTimer);for(var e in $.contextMenu.menus){var t=$.contextMenu.menus[e].selector;$(t).contextMenu(!1)}var n=this;this._menuTimer=setTimeout(function(){for(var e in $.contextMenu.menus){var t=$.contextMenu.menus[e].selector;$(t).contextMenu(!0)}n._menuTimer=null},0)},save:function(){var e={};e.floating=[];for(var t=0;t<this._floatingList.length;++t)e.floating.push(this._floatingList[t].__save());return e.root=this._root.__save(),$.isEmptyObject(this._collapser)||(e.collapsers={left:this._collapser[wcDocker.DOCK.LEFT].__save(),right:this._collapser[wcDocker.DOCK.RIGHT].__save(),bottom:this._collapser[wcDocker.DOCK.BOTTOM].__save()}),JSON.stringify(e,function(e,t){return t==Infinity?"Infinity":t})},restore:function(e){var t=JSON.parse(e,function(e,t){return t==="Infinity"?Infinity:t});this.clear(),this._root=this.__create(t.root,this,this.$container),this._root.__restore(t.root,this);for(var n=0;n<t.floating.length;++n){var r=this.__create(t.floating[n],this,this.$container);r.__restore(t.floating[n],this)}this.__forceUpdate(!1);if(!$.isEmptyObject(t.collapsers)&&this.isCollapseEnabled()){this.__initCollapsers(),this._collapser[wcDocker.DOCK.LEFT].__restore(t.collapsers.left,this),this._collapser[wcDocker.DOCK.RIGHT].__restore(t.collapsers.right,this),this._collapser[wcDocker.DOCK.BOTTOM].__restore(t.collapsers.bottom,this);var i=this;setTimeout(function(){i.__forceUpdate()})}},clear:function(){this._root=null,this.trigger(wcDocker.EVENT.CLOSED);for(var e=0;e<this._splitterList.length;++e)this._splitterList[e].__destroy();for(var e=0;e<this._frameList.length;++e)this._frameList[e].__destroy();$.isEmptyObject(this._collapser)||(this._collapser[wcDocker.DOCK.LEFT].__destroy(),this._collapser[wcDocker.DOCK.RIGHT].__destroy(),this._collapser[wcDocker.DOCK.BOTTOM].__destroy(),this._collapser={});while(this._frameList.length)this._frameList.pop();while(this._floatingList.length)this._floatingList.pop();while(this._splitterList.length)this._splitterList.pop()},__init:function(){function t(t){var n=e.__mouse(t);e._mouseOrigin.x=n.x,e._mouseOrigin.y=n.y}function n(t){var n=e.__mouse(t);if(n.which===3)return!0;e.$container.removeClass("wcDisableSelection");if(e._draggingFrame)for(var r=0;r<e._frameList.length;++r)e._frameList[r].__shadow(!1);if(e._ghost&&(e._draggingFrame||e._creatingPanel)){var i=e._ghost.anchor();if(e._draggingFrame){if(!i){e._draggingFrameTab||e._draggingFrame.panel(0);if(e._draggingFrameTab||!e.__isLastFrame(e._draggingFrame)){var s=e.movePanel(e._draggingFrame.panel(),wcDocker.DOCK.FLOAT,null,e._ghost.__rect());if(!e._draggingFrameTab)while(e._draggingFrame.panel())e.movePanel(e._draggingFrame.panel(),wcDocker.DOCK.STACKED,s,{tabOrientation:e._draggingFrame._tabOrientation});var o=s._parent;o instanceof wcFrame&&(o.pos(n.x,n.y+e._ghost.__rect().h/2-10,!0),o._size.x=e._ghost.__rect().w,o._size.y=e._ghost.__rect().h),o.__update(),e.__focus(o)}}else if(!i.self&&i.loc!==undefined)if(i.tab&&i.item._parent._parent==e._draggingFrame)e._draggingFrame.tabOrientation(i.tab);else{var u=e._draggingFrame._curTab;e._draggingFrameTab||e._draggingFrame.panel(0);var s;i.item&&(s=i.item._parent);if(s===e._draggingFrame.panel()){if(e._draggingFrame._panelList.length===1)return;for(var r=0;r<e._draggingFrame._panelList.length;++r)if(s!==e._draggingFrame._panelList[r]){s=e._draggingFrame._panelList[r],u--;break}}s=e.movePanel(e._draggingFrame.panel(),i.loc,s,e._ghost.rect()),s._parent.panel(s._parent._panelList.length-1,!0);if(!e._draggingFrameTab){var a=e._ghost.rect();a.tabOrientation||(a.tabOrientation=e._draggingFrame.tabOrientation());while(e._draggingFrame.panel())e.movePanel(e._draggingFrame.panel(),wcDocker.DOCK.STACKED,s,a)}else{var o=s._parent;o instanceof wcFrame&&(u+=o._panelList.length)}var o=s._parent;o instanceof wcFrame&&o.panel(u),e.__focus(o)}}else if(e._creatingPanel){var f=wcDocker.DOCK.FLOAT,l=null;i&&(f=i.loc,l=i.panel),e.addPanel(e._creatingPanel,f,l,e._ghost.rect())}e._ghost.destroy(),e._ghost=null,e.trigger(wcDocker.EVENT.END_DOCK),e.__update()}return e._draggingSplitter&&(e._draggingSplitter.$pane[0].removeClass("wcResizing"),e._draggingSplitter.$pane[1].removeClass("wcResizing")),e._draggingSplitter=null,e._draggingFrame=null,e._draggingFrameSizer=null,e._draggingFrameTab=null,e._draggingFrameTopper=!1,e._draggingCustomTabFrame=null,e._removingPanel=null,!0}function o(t){i=t;var n=e.__mouse(t);if(n.which===3||!e._draggingSplitter&&!e._draggingFrameSizer&&!e._draggingCustomTabFrame&&!e._ghost&&!e._draggingFrame&&!e._draggingFrameTab)return!0;var u=(new Date).getTime();if(u-r<e._options.responseRate)return s||(s=setTimeout(function(){r=0,s=0,o(i)},e._options.responseRate)),!0;r=(new Date).getTime();if(e._draggingSplitter)e._draggingSplitter.__moveBar(n);else if(e._draggingFrameSizer){var a=e.$container.offset();n.x+=a.left,n.y+=a.top,e._draggingFrame.__resize(e._draggingFrameSizer,n),e._draggingFrame.__update()}else if(e._draggingCustomTabFrame){var f=$(t.target).hasClass("wcPanelTab")?$(t.target):$(t.target).parents(".wcPanelTab");e._draggingFrameTab&&f&&f.length&&e._draggingFrameTab!==t.target&&(e._draggingFrameTab=e._draggingCustomTabFrame.moveTab(parseInt($(e._draggingFrameTab).attr("id")),parseInt(f.attr("id"))))}else if(e._ghost)if(e._draggingFrame){e._ghost.__move(n);var l=!e._draggingFrame._isFloating&&n.which!==1,c=!1;if(!e._draggingFrame.__checkAnchorDrop(n,!0,e._ghost,e._draggingFrame._panelList.length>1&&e._draggingFrameTab,e._draggingFrameTopper)){e._draggingFrame.__shadow(!0),e.__focus();if(!l)for(var h=0;h<e._frameList.length;++h)if(e._frameList[h]!==e._draggingFrame&&e._frameList[h].__checkAnchorDrop(n,!1,e._ghost,!0,e._draggingFrameTopper)){e._draggingFrame.__shadow(!0);return}e._ghost.anchor(n,null)}else{e._draggingFrame.__shadow(!1);var p=$(document.elementFromPoint(n.x,n.y)),f=p.hasClass("wcPanelTab")?p:p.parents(".wcPanelTab");e._draggingFrameTab&&f.length&&e._draggingFrameTab!==f[0]&&(e._draggingFrameTab=e._draggingFrame.__tabMove(parseInt($(e._draggingFrameTab).attr("id")),parseInt(f.attr("id"))))}}else e._creatingPanel&&e._ghost.update(n);else e._draggingFrame&&!e._draggingFrameTab&&(e._draggingFrame.__move(n),e._draggingFrame.__update());return!0}function u(){return this._contextTimer&&clearTimeout(this._contextTimer),$(".wcFrame").contextMenu(!1),this._contextTimer=setTimeout(function(){$(".wcFrame").contextMenu(!0),this._contextTimer=null},100),!0}function a(){return!1}function f(){e._ghost&&e._ghost.$ghost.stop().fadeIn(200)}function l(){e._ghost&&e._ghost.$ghost.stop().fadeOut(200)}function c(t){e._modalList.length&&e._modalList[e._modalList.length-1].__focus(!0)}function h(e){e.preventDefault(),e.returnValue=!1}function p(){e.$container.addClass("wcDisableSelection")}function d(t){e.$container.removeClass("wcDisableSelection");for(var n=0;n<e._tabList.length;++n){var r=e._tabList[n];if(r.$close[0]===this){var i=r.tab();r.removeTab(i),t.stopPropagation();return}if(r.$tabLeft[0]===this){r._tabScrollPos-=r.$tabBar.width()/2,r._tabScrollPos<0&&(r._tabScrollPos=0),r.__updateTabs(),t.stopPropagation();return}if(r.$tabRight[0]===this){r._tabScrollPos+=r.$tabBar.width()/2,r.__updateTabs(),t.stopPropagation();return}}}function v(){e.$container.removeClass("wcDisableSelection");for(var t=0;t<e._frameList.length;++t){var n=e._frameList[t];if(n.$close[0]===this){var r=n.panel();e.removePanel(r),e.__update();return}if(n.$collapse[0]===this){var i=n.$collapse.children("div"),s=wcDocker.DOCK.BOTTOM;i.hasClass("wcCollapseLeft")?s=wcDocker.DOCK.LEFT:i.hasClass("wcCollapseRight")&&(s=wcDocker.DOCK.RIGHT);if(n.isCollapser()){var o={};switch(s){case wcDocker.DOCK.LEFT:o.w=n.$frame.width();break;case wcDocker.DOCK.RIGHT:o.w=n.$frame.width();break;case wcDocker.DOCK.BOTTOM:o.h=n.$frame.height()}var u=e._collapser[wcDocker.DOCK.LEFT]._parent.right();n.collapse(!0),e.movePanel(n.panel(),s,u,o)}else e.movePanel(n.panel(),s,wcDocker.COLLAPSED);e.__update();return}if(n.$tabLeft[0]===this){n._tabScrollPos-=n.$tabBar.width()/2,n._tabScrollPos<0&&(n._tabScrollPos=0),n.__updateTabs();return}if(n.$tabRight[0]===this){n._tabScrollPos+=n.$tabBar.width()/2,n.__updateTabs();return}for(var a=0;a<n._buttonList.length;++a)if(n._buttonList[a][0]===this){var f=n._buttonList[a],l={name:f.data("name"),isToggled:!1};f.hasClass("wcFrameButtonToggler")&&(f.toggleClass("wcFrameButtonToggled"),f.hasClass("wcFrameButtonToggled")&&(l.isToggled=!0));var r=n.panel();r.buttonState(l.name,l.isToggled),r.__trigger(wcDocker.EVENT.BUTTON,l);return}}}function m(t){var n=e.__mouse(t);if(n.which!==2)return;var r=parseInt($(this).attr("id"));for(var i=0;i<e._frameList.length;++i){var s=e._frameList[i];if(s.$tabBar[0]===$(this).parents(".wcFrameTitleBar")[0]){var o=s._panelList[r];e._removingPanel===o&&(e.removePanel(o),e.__update());return}}}function g(t){var n=e.__mouse(t);if(n.which!==1)return!0;e.$container.addClass("wcDisableSelection");for(var r=0;r<e._splitterList.length;++r)if(e._splitterList[r].$bar[0]===this){e._draggingSplitter=e._splitterList[r],e._draggingSplitter.$pane[0].addClass("wcResizing"),e._draggingSplitter.$pane[1].addClass("wcResizing"),t.preventDefault();break}return!0}function y(t){var n=e.__mouse(t);if(n.which===3)return!0;if($(t.target).hasClass("wcFrameButton")||$(t.target).parents(".wcFrameButton").length)return!0;e.$container.addClass("wcDisableSelection");for(var r=0;r<e._frameList.length;++r)if(e._frameList[r].$titleBar[0]==this||e._frameList[r].$tabBar[0]==this){e._draggingFrame=e._frameList[r],e._draggingFrame.__anchorMove(n);var i=$(t.target).hasClass("wcPanelTab")?$(t.target):$(t.target).parents(".wcPanelTab");if(i&&i.length){var s=parseInt(i.attr("id"));e._draggingFrame.panel(s,!0),e._draggingFrameTab=i[0],$(window).focus()}var o=!0;e._draggingFrameTab?i.hasClass("wcNotMoveable")&&(o=!1):e._draggingFrame._isFloating&&n.which===1&&(o=!1);if(o){!e._draggingFrameTab&&e._draggingFrame.isCollapser()&&(e._draggingFrameTab=e._draggingFrame.panel()),e._draggingFrameTopper=$(t.target).parents(".wcFrameTopper").length>0;var u=e._draggingFrame.__rect();e._ghost=new wcGhost(u,n,e),e._draggingFrame.__checkAnchorDrop(n,!0,e._ghost,!0,e._draggingFrameTopper),e.trigger(wcDocker.EVENT.BEGIN_DOCK)}break}for(var r=0;r<e._tabList.length;++r)if(e._tabList[r].$tabBar[0]==this){e._draggingCustomTabFrame=e._tabList[r];var i=$(t.target).hasClass("wcPanelTab")?$(t.target):$(t.target).parents(".wcPanelTab");if(i&&i.length){var s=parseInt(i.attr("id"));e._draggingCustomTabFrame.tab(s,!0),e._draggingFrameTab=i[0]}break}return e._draggingFrame&&e.__focus(e._draggingFrame),!0}function b(t){var n=e.__mouse(t);if(n.which===3)return!0;for(var r=0;r<e._frameList.length;++r)if(e._frameList[r].panel()&&e._frameList[r].panel().layout().$table[0]==this){setTimeout(function(){e.__focus(e._frameList[r])},10);break}return!0}function w(t){var n=e.__mouse(t);if(n.which===3)return!0;e.$container.addClass("wcDisableSelection");for(var r=0;r<e._frameList.length;++r)if(e._frameList[r]._isFloating){if(e._frameList[r].$top[0]==this){e._draggingFrame=e._frameList[r],e._draggingFrameSizer=["top"];break}if(e._frameList[r].$bottom[0]==this){e._draggingFrame=e._frameList[r],e._draggingFrameSizer=["bottom"];break}if(e._frameList[r].$left[0]==this){e._draggingFrame=e._frameList[r],e._draggingFrameSizer=["left"];break}if(e._frameList[r].$right[0]==this){e._draggingFrame=e._frameList[r],e._draggingFrameSizer=["right"];break}if(e._frameList[r].$corner1[0]==this){e._draggingFrame=e._frameList[r],e._draggingFrameSizer=["top","left"];break}if(e._frameList[r].$corner2[0]==this){e._draggingFrame=e._frameList[r],e._draggingFrameSizer=["top","right"];break}if(e._frameList[r].$corner3[0]==this){e._draggingFrame=e._frameList[r],e._draggingFrameSizer=["bottom","right"];break}if(e._frameList[r].$corner4[0]==this){e._draggingFrame=e._frameList[r],e._draggingFrameSizer=["bottom","left"];break}}return e._draggingFrame&&e.__focus(e._draggingFrame),!0}function E(t){var n=e.__mouse(t);if(n.which!==1)return!0;var r=$(this).data("panel"),i=e.panelTypeInfo(r);if(i){var s={x:n.x-250,y:n.y,w:500,h:500};e.$container.addClass("wcDisableSelection"),e._ghost=new wcGhost(s,n,e),e._ghost.update(n),e._ghost.anchor(n,e._ghost.anchor()),e._creatingPanel=r,e.__focus(),e.trigger(wcDocker.EVENT.BEGIN_DOCK)}}function S(t){var n=e.__mouse(t);if(n.which!==2)return!0;var r=parseInt($(this).attr("id"));for(var i=0;i<e._frameList.length;++i){var s=e._frameList[i];if(s.$tabBar[0]===$(this).parents(".wcFrameTitleBar")[0]){var o=s._panelList[r];return e._removingPanel=o,!0}}return!0}function x(t){t.keyCode==27&&e._ghost&&(e._ghost.destroy(),e._ghost=!1,e.trigger(wcDocker.EVENT.END_DOCK),e._draggingFrame&&e._draggingFrame.__shadow(!1),e._creatingPanel=!1,e._draggingSplitter=null,e._draggingFrame=null,e._draggingFrameSizer=null,e._draggingFrameTab=null,e._draggingFrameTopper=!1,e._draggingCustomTabFrame=null,e._removingPanel=null)}var e=this;this.__compatibilityCheck(),this._root=null,this.__addPlaceholder(),this._options.allowContextMenu&&this.menu(".wcFrame",[],!0),this.theme(this._options.theme),this._updateId=setInterval(function(){if(e._dirty){e._dirty=!1,e._root&&e._root.__update();for(var t=0;t<e._floatingList.length;++t)e._floatingList[t].__update()}},this._options.responseRate),$(window).resize(this.__resize.bind(this)),$("body").on("contextmenu","a, img",u),$("body").on("contextmenu",".wcSplitterBar",a),$("body").on("mouseenter",".wcMenuCreatePanel",f),$("body").on("mouseleave",".wcMenuCreatePanel",l),$("body").on("mousemove",o),$("body").on("touchmove",o),$("body").on("mousedown",t),$("body").on("touchstart",t),$("body").on("mousedown",".wcModalBlocker",c),$("body").on("touchstart",".wcModalBlocker",c),$("body").on("mousedown",".wcPanelTab",h),$("body").on("touchstart",".wcPanelTab",h),$("body").on("mousedown",".wcFrameButtonBar > .wcFrameButton",p),$("body").on("touchstart",".wcFrameButtonBar > .wcFrameButton",p),$("body").on("mousedown",".wcFrameTitleBar",y),$("body").on("touchstart",".wcFrameTitleBar",y),$("body").on("mousedown",".wcSplitterBar",g),$("body").on("touchstart",".wcSplitterBar",g),$("body").on("mousedown",".wcPanelTab",S),$("body").on("touchstart",".wcPanelTab",S),$("body").on("mouseup",".wcPanelTab",m),$("body").on("touchend",".wcPanelTab",m),$("body").on("mousedown",".wcLayout",b),$("body").on("touchstart",".wcLayout",b),$("body").on("mousedown",".wcFrameEdge",w),$("body").on("touchstart",".wcFrameEdge",w),$("body").on("mousedown",".wcCreatePanel",E),$("body").on("touchstart",".wcCreatePanel",E),$("body").on("mouseup",n),$("body").on("touchend",n),$("body").on("click",".wcCustomTab .wcFrameButton",d),$("body").on("click",".wcFrameButtonBar > .wcFrameButton",v),$("body").on("keyup",x);var r=(new Date).getTime(),i=null,s=0},__compatibilityCheck:function(){Function.prototype.bind||(Function.prototype.bind=function(e){if(typeof this!="function")throw new TypeError("Function.prototype.bind - what is trying to be bound is not callable");var t=Array.prototype.slice.call(arguments,1),n=this,r=function(){},i=function(){return n.apply(this instanceof r&&e?this:e,t.concat(Array.prototype.slice.call(arguments)))};return r.prototype=this.prototype,i.prototype=new r,i}),Array.prototype.indexOf||(Array.prototype.indexOf=function(e){var t=this.length>>>0,n=Number(arguments[1])||0;n=n<0?Math.ceil(n):Math.floor(n),n<0&&(n+=t);for(;n<t;n++)if(n in this&&this[n]===e)return n;return-1});var e=function(){var e=3,t=document.createElement("div"),n=t.getElementsByTagName("i");while(t.innerHTML="<!--[if gt IE "+ ++e+"]><i></i><![endif]-->",n[0]);return e>4?e:undefined}();if(e<9)this._canOrientTabs=!1;else{function t(){var e="transform WebkitTransform MozTransform OTransform msTransform".split(" "),t=document.createElement("div");for(var n=0;n<e.length;n++)if(t&&t.style[e[n]]!==undefined)return!0;return!1}this._canOrientTabs=t()}var n=/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);$("body").addClass(n?"wcMobile":"wcDesktop")},__initCollapsers:function(){function e(e){return e&&e instanceof wcFrame&&e.panel()&&!e.panel().moveable()?!0:!1}function i(e){this._collapser[e]=this.__addCollapser(e,t),t=this._collapser[e]._parent,this._frameList.push(this._collapser[e]._drawer._frame)}if(!this.isCollapseEnabled()||!$.isEmptyObject(this._collapser))return;var t=this._root;while(t){if(!(t instanceof wcSplitter))break;var n=e(t._pane[0]),r=e(t._pane[1]);if(n&&!r)t=t._pane[1];else if(r&&!n)t=t._pane[0];else if(!n&&!r)break}i.call(this,wcDocker.DOCK.LEFT),i.call(this,wcDocker.DOCK.RIGHT),i.call(this,wcDocker.DOCK.BOTTOM);var s=this;setTimeout(function(){s.__update()})},__update:function(e){this._dirty=!0},__forceUpdate:function(e){this._dirty=!1,this._root&&this._root.__update(e);for(var t=0;t<this._floatingList.length;++t)this._floatingList[t].__update()},__mouse:function(e){if(e.originalEvent&&(e.originalEvent.touches||e.originalEvent.changedTouches)){var t=e.originalEvent.touches[0]||e.originalEvent.changedTouches[0];return{x:t.clientX,y:t.clientY,which:1}}return{x:e.clientX||e.pageX,y:e.clientY||e.pageY,which:e.which||1}},__resize:function(e){this._resizeData.time=new Date,this._resizeData.timeout||(this._resizeData.timeout=!0,setTimeout(this.__resizeEnd.bind(this),this._resizeData.delta),this.__trigger(wcDocker.EVENT.RESIZE_STARTED)),this.__trigger(wcDocker.EVENT.RESIZED),this.__update(!1)},__resizeEnd:function(){new Date-this._resizeData.time<this._resizeData.delta?setTimeout(this.__resizeEnd.bind(this),this._resizeData.delta):(this._resizeData.timeout=!1,this.__trigger(wcDocker.EVENT.RESIZE_ENDED))},__focus:function(e,t){var n=this._focusFrame!=e;this._focusFrame&&(this._focusFrame._isFloating&&this._focusFrame.$frame.removeClass("wcFloatingFocus"),this._focusFrame.__trigger(wcDocker.EVENT.LOST_FOCUS),this._focusFrame.isCollapser()&&n&&(this._focusFrame.collapse(),this._focusFrame.panel(-1)),this._focusFrame=null),this._focusFrame=e,this._focusFrame&&(this._focusFrame._isFloating&&(this._focusFrame.$frame.addClass("wcFloatingFocus"),n&&$("body").append(this._focusFrame.$frame)),this._focusFrame.__focus(t),this._focusFrame.__trigger(wcDocker.EVENT.GAIN_FOCUS))},__trigger:function(e,t){if(!e)return;if(this._events[e])for(var n=0;n<this._events[e].length;++n)this._events[e][n].call(this,t)},__isLastPanel:function(e){for(var t=0;t<this._frameList.length;++t){var n=this._frameList[t];if(n._isFloating||n.isCollapser())continue;for(var r=0;r<n._panelList.length;++r){var i=n._panelList[r];if(i!==e&&i.moveable())return!1}}return!0},__isLastFrame:function(e){for(var t=0;t<this._frameList.length;++t){var n=this._frameList[t];if(n._isFloating||n===e||n.isCollapser())continue;for(var r=0;r<n._panelList.length;++r){var i=n._panelList[r];if(i.moveable())return!1}}return!0},__create:function(e,t,n){switch(e.type){case"wcSplitter":var r=new wcSplitter(n,t,e.horizontal);return r.scrollable(0,!1,!1),r.scrollable(1,!1,!1),r;case"wcFrame":var i=new wcFrame(n,t,e.floating);return this._frameList.push(i),e.floating&&this._floatingList.push(i),i;case"wcPanel":for(var s=0;s<this._dockPanelTypeList.length;++s)if(this._dockPanelTypeList[s].name===e.panelType){var o=new wcPanel(e.panelType,this._dockPanelTypeList[s].options);o._parent=t,o.__container(this.$transition);var u=this._dockPanelTypeList[s].options&&this._dockPanelTypeList[s].options.options||{};o._panelObject=new this._dockPanelTypeList[s].options.onCreate(o,u),o.__container(n);break}return o}return null},__addPanelGrouped:function(e,t,n){var r=t;t instanceof wcPanel&&(r=t._parent);if(r instanceof wcFrame){n&&n.tabOrientation&&r.tabOrientation(n.tabOrientation),r.addPanel(e);return}this.__addPanelAlone(e,wcDocker.DOCK.LEFT,t,n)},__addPanelAlone:function(e,t,n,r){if(r){var i=this.$container.width(),s=this.$container.height();r.hasOwnProperty("x")&&(r.x=this.__stringToPixel(r.x,i)),r.hasOwnProperty("y")&&(r.y=this.__stringToPixel(r.y,s)),r.hasOwnProperty("w")||(r.w=e.initSize().x),r.hasOwnProperty("h")||(r.h=e.initSize().y),r.w=this.__stringToPixel(r.w,i),r.h=this.__stringToPixel(r.h,s),e._size.x=r.w,e._size.y=r.h}if(n===wcDocker.COLLAPSED){this.__initCollapsers();if(this._collapser[t]){n=this._collapser[t]._drawer._frame.addPanel(e);var o=this;return setTimeout(function(){o.__update()}),e}return console.log('ERROR: Attempted to collapse panel "'+e._type+'" to invalid location: '+t),!1}if(t===wcDocker.DOCK.FLOAT||t===wcDocker.DOCK.MODAL){var u=new wcFrame(this.$container,this,!0);r&&r.tabOrientation&&u.tabOrientation(r.tabOrientation),this._frameList.push(u),this._floatingList.push(u),this.__focus(u),u.addPanel(e),u.pos(e._pos.x,e._pos.y,!1),t===wcDocker.DOCK.MODAL&&(u.$modalBlocker=$('<div class="wcModalBlocker"></div>'),u.$frame.prepend(u.$modalBlocker),e.moveable(!1),u.$frame.addClass("wcModal"),this._modalList.push(u));if(r){var a=u.pos(undefined,undefined,!0);r.hasOwnProperty("x")&&(a.x=r.x+r.w/2),r.hasOwnProperty("y")&&(a.y=r.y+r.h/2),u.pos(a.x,a.y,!0),u._size={x:r.w,y:r.h}}return}if(n){var f=n._parent,l=n;while(!(f instanceof wcSplitter||f instanceof wcDocker))l=f,f=f._parent;if(f instanceof wcSplitter){var c,h=f.pane(0),p=f.pane(1),d={x:-1,y:-1};h===l?(c=new wcSplitter(this.$transition,f,t!==wcDocker.DOCK.BOTTOM&&t!==wcDocker.DOCK.TOP),d.x=f.$pane[0].width(),d.y=f.$pane[0].height(),f.pane(0,c)):(c=new wcSplitter(this.$transition,f,t!==wcDocker.DOCK.BOTTOM&&t!==wcDocker.DOCK.TOP),d.x=f.$pane[1].width(),d.y=f.$pane[1].height(),f.pane(1,c));if(c){c.scrollable(0,!1,!1),c.scrollable(1,!1,!1),r||(r={w:e._size.x,h:e._size.y});if(r){r.w<0&&(r.w=d.x/2),r.h<0&&(r.h=d.y/2);switch(t){case wcDocker.DOCK.LEFT:c.pos(r.w/d.x);break;case wcDocker.DOCK.RIGHT:c.pos(1-r.w/d.x);break;case wcDocker.DOCK.TOP:c.pos(r.h/d.y);break;case wcDocker.DOCK.BOTTOM:c.pos(1-r.h/d.y)}}else c.pos(.5);u=new wcFrame(this.$transition,c,!1),this._frameList.push(u),t===wcDocker.DOCK.LEFT||t===wcDocker.DOCK.TOP?(c.pane(0,u),c.pane(1,l)):(c.pane(0,l),c.pane(1,u)),u.addPanel(e)}return}}var v=this,m=this.$container,u=new wcFrame(this.$transition,v,!1);this._frameList.push(u);if(!v._root)v._root=u,u.__container(m);else{var c=new wcSplitter(m,v,t!==wcDocker.DOCK.BOTTOM&&t!==wcDocker.DOCK.TOP);if(c){u._parent=c,c.scrollable(0,!1,!1),c.scrollable(1,!1,!1);var d={x:m.width(),y:m.height()};if(!r)c.__findBestPos();else{r.w<0&&(r.w=d.x/2),r.h<0&&(r.h=d.y/2);switch(t){case wcDocker.DOCK.LEFT:c.pos(r.w/d.x);break;case wcDocker.DOCK.RIGHT:c.pos(1-r.w/d.x);break;case wcDocker.DOCK.TOP:c.pos(r.h/d.y);break;case wcDocker.DOCK.BOTTOM:c.pos(1-r.h/d.y)}}t===wcDocker.DOCK.LEFT||t===wcDocker.DOCK.TOP?(c.pane(0,u),c.pane(1,v._root)):(c.pane(0,v._root),c.pane(1,u)),v._root=c}}u.addPanel(e)},__addCollapser:function(e,t){var n=null;if(t){var r=t._parent,i=t;while(!(r instanceof wcSplitter||r instanceof wcDocker))i=r,r=r._parent;if(r instanceof wcSplitter){var s,o=r.pane(0),u=r.pane(1),a={x:-1,y:-1};o===i?(s=new wcSplitter(this.$transition,r,e!==wcDocker.DOCK.BOTTOM&&e!==wcDocker.DOCK.TOP),a.x=r.$pane[0].width(),a.y=r.$pane[0].height(),r.pane(0,s)):(s=new wcSplitter(this.$transition,r,e!==wcDocker.DOCK.BOTTOM&&e!==wcDocker.DOCK.TOP),a.x=r.$pane[1].width(),a.y=r.$pane[1].height(),r.pane(1,s));if(s){s.scrollable(0,!1,!1),s.scrollable(1,!1,!1),n=new wcCollapser(this.$transition,s,e);switch(e){case wcDocker.DOCK.TOP:case wcDocker.DOCK.LEFT:s.pos(0);break;case wcDocker.DOCK.BOTTOM:case wcDocker.DOCK.RIGHT:s.pos(1)}e===wcDocker.DOCK.LEFT||e===wcDocker.DOCK.TOP?(s.pane(0,n),s.pane(1,i)):(s.pane(0,i),s.pane(1,n))}}}return n},__addPlaceholder:function(e){this._placeholderPanel&&console.log("WARNING: wcDocker creating placeholder panel when one already exists"),this._placeholderPanel=new wcPanel(wcDocker.PANEL_PLACEHOLDER,{}),this._placeholderPanel._isPlaceholder=!0,this._placeholderPanel._parent=this,this._placeholderPanel.__container(this.$transition),this._placeholderPanel._panelObject=new function(e){e.title(!1),e.closeable(!1)}(this._placeholderPanel),e?this.__addPanelGrouped(this._placeholderPanel,e):this.__addPanelAlone(this._placeholderPanel,wcDocker.DOCK.TOP),this.__update()},__stringToPercent:function(e,t){if(typeof e=="string"){if(e.indexOf("%",e.length-1)!==-1)return parseFloat(e)/100;if(e.indexOf("px",e.length-2)!==-1)return parseFloat(e)/t}return parseFloat(e)},__stringToPixel:function(e,t){if(typeof e=="string"){if(e.indexOf("%",e.length-1)!==-1)return parseFloat(e)/100*t;if(e.indexOf("px",e.length-2)!==-1)return parseFloat(e)}return parseFloat(e)}},wcGhost.prototype={update:function(e){this.__move(e);for(var t=0;t<this._docker._floatingList.length;++t){var n=this._docker._floatingList[t].__rect();if(e.x>n.x&&e.y>n.y&&e.x<n.x+n.w&&e.y<n.y+n.h){this._docker._floatingList[t].__checkAnchorDrop(e,!1,this,!0)?this._anchor.panel=this._docker._floatingList[t].panel():this.anchor(e,null);return}}for(var t=0;t<this._docker._frameList.length;++t){var n=this._docker._frameList[t].__rect();if(e.x>n.x&&e.y>n.y&&e.x<n.x+n.w&&e.y<n.y+n.h){this._docker._frameList[t].__checkAnchorDrop(e,!1,this,!0)?this._anchor.panel=this._docker._frameList[t].panel():this.anchor(e,null);return}}},anchor:function(e,t){if(typeof e=="undefined")return this._anchor;if(t&&this._anchor&&t.loc===this._anchor.loc&&t.item===this._anchor.item)return;var n={x:parseInt(this.$ghost.css("left")),y:parseInt(this.$ghost.css("top")),w:parseInt(this.$ghost.css("width")),h:parseInt(this.$ghost.css("height"))};this._anchorMouse={x:n.x-e.x,y:n.y-e.y},this._rect.x=-this._anchorMouse.x,this._rect.y=-this._anchorMouse.y;if(!t){if(!this._anchor)return;this._anchor=null,this.$ghost.show(),this.$ghost.stop().animate({opacity:.3,"margin-left":this._rect.x-this._rect.w/2+"px","margin-top":this._rect.y-10+"px",width:this._rect.w+"px",height:this._rect.h+"px"},150);return}this._anchor=t;var r=.8;t.self&&t.loc===wcDocker.DOCK.STACKED?(r=0,this.$ghost.hide()):this.$ghost.show(),this.$ghost.stop().animate({opacity:r,"margin-left":"2px","margin-top":"2px",border:"0px",left:t.x+"px",top:t.y+"px",width:t.w+"px",height:t.h+"px"},150)},rect:function(){return{x:this.$ghost.offset().left,y:this.$ghost.offset().top,w:parseInt(this.$ghost.css("width")),h:parseInt(this.$ghost.css("height")),tabOrientation:this._anchor&&this._anchor.tab}},destroy:function(){this.__destroy()},__init:function(e,t){this.$ghost=$('<div class="wcGhost">').css("opacity",0).css("top",e.y+"px").css("left",e.x+"px").css("width",e.w+"px").css("height",e.h+"px"),this._anchorMouse={x:e.x-t.x,y:e.y-t.y},this._rect={x:-this._anchorMouse.x,y:-this._anchorMouse.y,w:e.w,h:e.h},$("body").append(this.$ghost),this.anchor(t,e)},__move:function(e){if(this._anchor)return;var t=parseInt(this.$ghost.css("left")),n=parseInt(this.$ghost.css("top"));t=e.x+this._anchorMouse.x,n=e.y+this._anchorMouse.y,this.$ghost.css("left",t+"px"),this.$ghost.css("top",n+"px")},__rect:function(){return this._rect},__destroy:function(){this.$ghost.stop().animate({opacity:0},{duration:175,complete:function(){$(this).remove()}})}},wcLayout.prototype={addItem:function(e,t,n,r,i){if(typeof t=="undefined"||t<0)t=0;if(typeof n=="undefined"||n<0)n=0;if(typeof r=="undefined"||r<=0)r=1;if(typeof i=="undefined"||i<=0)i=1;this.__resizeGrid(t+r-1,n+i-1);if(r>1||i>1)if(!this.__mergeGrid(t,n,r,i))return!1;return this._grid[n][t].$el.append($(e)),this.item(t,n)},item:function(e,t){if(t>=this._grid.length)return!1;if(e>=this._grid[t].length)return!1;var n=this,r={$:n._grid[t][e].$el,css:function(i,s){if(n._grid[t][e].$el){if(s===undefined)return n._grid[t][e].$el.css(i);n._grid[t][e].$el.css(i,s)}return r},stretch:function(i,s){return n.itemStretch(e,t,i,s),r}};return r},itemStretch:function(e,t,n,r){var i=this._batchProcess;this._batchProcess=!0,this.__resizeGrid(e,t);var s=this._grid[t][e];return s.x<0||s.y<0?!1:(n!==undefined&&(s.sx=n),r!==undefined&&(s.sy=r),this._batchProcess=i,i||this.__resizeGrid(0,0),!0)},clear:function(){var e=this.showGrid(),t=this.gridSpacing(),n=this.gridAlternate();this.$table.remove(),this.__init(),this.showGrid(e),this.gridSpacing(t),this.gridAlternate(n),this._grid=[]},startBatch:function(){this._batchProcess=!0},finishBatch:function(){this._batchProcess=!1,this.__resizeGrid(0,0)},showGrid:function(e){return typeof e!="undefined"&&this.$table.toggleClass("wcLayoutGrid",e),this.$table.hasClass("wcLayoutGrid")},gridSpacing:function(e){return typeof e!="undefined"&&this.$table.css("border-spacing",e+"px"),parseInt(this.$table.css("border-spacing"))},gridAlternate:function(e){return typeof e!="undefined"&&this.$table.toggleClass("wcLayoutGridAlternate",e),this.$table.hasClass("wcLayoutGridAlternate")},scene:function(){return console.log("wcLayout.scene() has been deprecated, please use wcLayout.$table instead. This function will be removed in the next version."),this.$table},__init:function(){this.$table=$('<table class="wcLayout wcWide wcTall"></table>'),this.$table.append($("<tbody></tbody>")),this.__container(this.$container)},__update:function(){},__resizeGrid:function(e,t){for(var n=0;n<=t;++n){if(this._grid.length<=n){var r=[];r.$row=$("<tr>"),this._grid.push(r)}for(var i=0;i<=e;++i)this._grid[n].length<=i&&this._grid[n].push({$el:$("<td>"),x:0,y:0,sx:"",sy:""})}if(!this._batchProcess){var s=this.$table.find("tbody");$(".wcDockerTransition").append(s);var o=$("<tbody>");for(var n=0;n<this._grid.length;++n){var u=null;for(var i=0;i<this._grid[n].length;++i){var a=this._grid[n][i];a.$el&&(u||(u=this._grid[n].$row,o.append(u)),a.$el.css("width",a.sx),a.$el.css("height",a.sy),u.append(a.$el))}}this.$table.append(o),s.remove()}},__mergeGrid:function(e,t,n,r){for(var i=0;i<r;++i)for(var s=0;s<n;++s){var o=this._grid[t+i][e+s];if(!o.$el||o.x!==0||o.y!==0)return!1}var o=this._grid[t][e];n>1&&(o.$el.attr("colspan",""+n),o.x=n-1),r>1&&(o.$el.attr("rowspan",""+r),o.y=r-1);for(var i=0;i<r;++i)for(var s=0;s<n;++s)if(i!==0||s!==0){var o=this._grid[t+i][e+s];o.$el.remove(),o.$el=null,o.x=-s,o.y=-i}return!0},__checkAnchorDrop:function(e,t,n,r,i,s,o,u){var a=i.outerWidth(),f=i.outerHeight(),l=i.offset(),c=i.find(".wcFrameTitleBar").height();s||(c=0);if(s){if((!u||u===wcDocker.TAB.TOP)&&e.y>=l.top&&e.y<=l.top+c&&e.x>=l.left&&e.x<=l.left+a)return n.anchor(e,{x:l.left-2,y:l.top-2,w:a,h:c-2,loc:wcDocker.DOCK.STACKED,tab:wcDocker.TAB.TOP,item:this,self:t===wcDocker.TAB.TOP||o}),!0;if(this._parent.docker()._canOrientTabs){if((!u||u===wcDocker.TAB.BOTTOM)&&e.y>=l.top+f-c&&e.y<=l.top+f&&e.x>=l.left&&e.x<=l.left+a)return n.anchor(e,{x:l.left-2,y:l.top+f-c-2,w:a,h:c,loc:wcDocker.DOCK.STACKED,tab:wcDocker.TAB.BOTTOM,item:this,self:t===wcDocker.TAB.BOTTOM}),!0;if((!u||u===wcDocker.TAB.LEFT)&&e.y>=l.top&&e.y<=l.top+f&&e.x>=l.left&&e.x<=l.left+c)return n.anchor(e,{x:l.left-2,y:l.top-2,w:c-2,h:f,loc:wcDocker.DOCK.STACKED,tab:wcDocker.TAB.LEFT,item:this,self:t===wcDocker.TAB.LEFT}),!0;if((!u||u===wcDocker.TAB.RIGHT)&&e.y>=l.top&&e.y<=l.top+f&&e.x>=l.left+a-c&&e.x<=l.left+a)return n.anchor(e,{x:l.left+a-c-2,y:l.top-2,w:c,h:f,loc:wcDocker.DOCK.STACKED,tab:wcDocker.TAB.RIGHT,item:this,self:t===wcDocker.TAB.RIGHT}),!0}}if(!r)return!1;if(this._parent instanceof wcPanel&&this._parent._isPlaceholder)return n.anchor(e,{x:l.left-2,y:l.top-2,w:a,h:f,loc:wcDocker.DOCK.TOP,item:this,self:!1}),!0;if(a<f){if(e.y>=l.top&&e.y<=l.top+f*.25&&e.x>=l.left&&e.x<=l.left+a)return n.anchor(e,{x:l.left-2,y:l.top-2,w:a,h:f*.5,loc:wcDocker.DOCK.TOP,item:this,self:!1}),!0;if(e.y>=l.top+f*.75&&e.y<=l.top+f&&e.x>=l.left&&e.x<=l.left+a)return n.anchor(e,{x:l.left-2,y:l.top+(f-f*.5)-2,w:a,h:f*.5,loc:wcDocker.DOCK.BOTTOM,item:this,self:!1}),!0}if(e.y>=l.top&&e.y<=l.top+f){if(e.x>=l.left&&e.x<=l.left+a*.25)return n.anchor(e,{x:l.left-2,y:l.top-2,w:a*.5,h:f,loc:wcDocker.DOCK.LEFT,item:this,self:!1}),!0;if(e.x>=l.left+a*.75&&e.x<=l.left+a)return n.anchor(e,{x:l.left+a*.5-2,y:l.top-2,w:a*.5,h:f,loc:wcDocker.DOCK.RIGHT,item:this,self:!1}),!0}if(a>=f){if(e.y>=l.top&&e.y<=l.top+f*.25&&e.x>=l.left&&e.x<=l.left+a)return n.anchor(e,{x:l.left-2,y:l.top-2,w:a,h:f*.5,loc:wcDocker.DOCK.TOP,item:this,self:!1}),!0;if(e.y>=l.top+f*.75&&e.y<=l.top+f&&e.x>=l.left&&e.x<=l.left+a)return n.anchor(e,{x:l.left-2,y:l.top+(f-f*.5)-2,w:a,h:f*.5,loc:wcDocker.DOCK.BOTTOM,item:this,self:!1}),!0}return!1},__container:function(e){return typeof e=="undefined"?this.$container:(this.$container=e,this.$container?this.$container.append(this.$table):this.$table.remove(),this.$container)},__destroy:function(){this.__container(null),this._parent=null,this.clear(),this.$table.remove(),this.$table=null}},wcPanel.prototype={docker:function(){var e=this._parent;while(e&&!(e instanceof wcDocker))e=e._parent;return e},title:function(e){return typeof e!="undefined"&&(e===!1?(this._titleVisible=!1,this.$titleText.text(this._type)):(this._title=e,this.$titleText.text(e)),this.$icon&&this.$titleText.prepend(this.$icon)),this._title},info:function(){return this.docker().panelTypeInfo(this._type)},layout:function(){return this._layout},focus:function(e){var t=this.docker();if(t){t.__focus(this._parent,e);for(var n=0;n<this._parent._panelList.length;++n)if(this._parent._panelList[n]===this){this._parent.panel(n);break}}},isVisible:function(){return this._isVisible},addButton:function(e,t,n,r,i,s){this._buttonList.push({name:e,className:t,toggleClassName:s,text:n,tip:r,isTogglable:i,isToggled:!1}),this._parent instanceof wcFrame&&this._parent.__update()},removeButton:function(e){for(var t=0;t<this._buttonList.length;++t)if(this._buttonList[t].name===e)return this._buttonList.splice(t,1),this._parent instanceof wcFrame&&this._parent.__onTabChange(),this._parent instanceof wcFrame&&this._parent.__update(),!0;return!1},buttonState:function(e,t){for(var n=0;n<this._buttonList.length;++n)if(this._buttonList[n].name===e)return typeof t!="undefined"&&(this._buttonList[n].isToggled=t,this._parent instanceof wcFrame&&this._parent.__onTabChange()),this._parent instanceof wcFrame&&this._parent.__update(),this._buttonList[n].isToggled;return!1},initPos:function(e,t){if(typeof e!="undefined"){var n=this.docker();n?this._pos.x=n.__stringToPercent(e,n.$container.width()):this._pos.x=e}if(typeof t!="undefined"){var n=this.docker();n?this._pos.y=n.__stringToPercent(t,n.$container.height()):this._pos.y=t}return{x:this._pos.x,y:this._pos.y}},initSize:function(e,t){if(typeof e!="undefined"){var n=this.docker();n?this._size.x=n.__stringToPixel(e,n.$container.width()):this._size.x=e}if(typeof t!="undefined"){var n=this.docker();n?this._size.y=n.__stringToPixel(t,n.$container.height()):this._size.y=t}return{x:this._size.x,y:this._size.y}},minSize:function(e,t){if(typeof e!="undefined"){var n=this.docker();n?this._minSize.x=n.__stringToPixel(e,n.$container.width()):this._minSize.x=e}if(typeof t!="undefined"){var n=this.docker();n?this._minSize.y=n.__stringToPixel(t,n.$container.height()):this._minSize.y=t}return{x:this._minSize.x,y:this._minSize.y}},maxSize:function(e,t){if(typeof e!="undefined"){var n=this.docker();n?this._maxSize.x=n.__stringToPixel(e,n.$container.width()):this._maxSize.x=e}if(typeof t!="undefined"){var n=this.docker();n?this._maxSize.y=n.__stringToPixel(t,n.$container.height()):this._maxSize.y=t}return{x:this._maxSize.x,y:this._maxSize.y}},width:function(){return this.$container?this.$container.width():0},height:function(){return this.$container?this.$container.height():0},icon:function(e){this.$icon||(this.$icon=$("<div>"),this.$titleText.prepend(this.$icon)),this.$icon.removeClass(),this.$icon.addClass("wcTabIcon "+e)},faicon:function(e){this.$icon||(this.$icon=$("<div>"),this.$titleText.prepend(this.$icon)),this.$icon.removeClass(),this.$icon.addClass("wcTabIcon fa fa-fw fa-"+e)},scrollable:function(e,t){return typeof e!="undefined"&&(this._scrollable.x=e?!0:!1,this._scrollable.y=t?!0:!1),{x:this._scrollable.x,y:this._scrollable.y}},scroll:function(e,t,n){return this.$container?(typeof e!="undefined"&&(n?this.$container.parent().stop().animate({scrollLeft:e,scrollTop:t},n):(this.$container.parent().scrollLeft(e),this.$container.parent().scrollTop(t))),{x:this.$container.parent().scrollLeft(),y:this.$container.parent().scrollTop()}):{x:0,y:0}},collapsible:function(e){return typeof e!="undefined"&&(this._collapsible=e?!0:!1),this._collapsible},overflowVisible:function(e){return typeof e!="undefined"&&(this._overflowVisible=e?!0:!1),this._overflowVisible},resizeVisible:function(e){return typeof e!="undefined"&&(this._resizeVisible=e?!0:!1),this._resizeVisible},moveable:function(e){return typeof e!="undefined"&&(this._moveable=e?!0:!1,this.$title.toggleClass("wcNotMoveable",!this._moveable)),this._moveable},closeable:function(e){return typeof e!="undefined"&&(this._closeable=e?!0:!1,this._parent&&this._parent.__update()),this._closeable},close:function(){this._parent&&this._parent.$close.click()},on:function(e,t){return e?(this._events[e]||(this._events[e]=[]),this._events[e].indexOf(t)!==-1?!1:(this._events[e].push(t),!0)):!1},off:function(e,t){if(typeof e=="undefined"){this._events={};return}if(this._events[e])if(typeof t=="undefined")this._events[e]=[];else for(var n=0;n<this._events[e].length;++n)if(this._events[e][n]===t){this._events[e].splice(n,1);break}},trigger:function(e,t){var n=this.docker();n&&n.trigger(e,t)},__init:function(){this._layout=new wcLayout(this.$container,this),this.$title=$('<div class="wcPanelTab">'),this.$titleText=$("<div>"+this._title+"</div>"),this.$title.append(this.$titleText),this._options.hasOwnProperty("title")&&this.title(this._options.title),this._options.icon&&this.icon(this._options.icon),this._options.faicon&&this.faicon(this._options.faicon)},__update:function(){this._layout.__update();if(!this.$container)return;this._resizeVisible?this._parent.$frame.removeClass("wcHideOnResize"):this._parent.$frame.addClass("wcHideOnResize");if(!this._initialized){this._initialized=!0;var e=this;setTimeout(function(){e.__trigger(wcDocker.EVENT.INIT)},0)}this.__trigger(wcDocker.EVENT.UPDATED);var t=this.$container.width(),n=this.$container.height();if(this._actualSize.x!==t||this._actualSize.y!==n)this._actualSize.x=t,this._actualSize.y=n,this._resizeData.time=new Date,this._resizeData.timeout||(this._resizeData.timeout=!0,setTimeout(this.__resizeEnd.bind(this),this._resizeData.delta),this.__trigger(wcDocker.EVENT.RESIZE_STARTED)),this.__trigger(wcDocker.EVENT.RESIZED);var r=this.$container.offset();if(this._actualPos.x!==r.left||this._actualPos.y!==r.top)this._actualPos.x=r.left,this._actualPos.y=r.top,this._moveData.time=new Date,this._moveData.timeout||(this._moveData.timeout=!0,setTimeout(this.__moveEnd.bind(this),this._moveData.delta),this.__trigger(wcDocker.EVENT.MOVE_STARTED)),this.__trigger(wcDocker.EVENT.MOVED)},__resizeEnd:function(){new Date-this._resizeData.time<this._resizeData.delta?setTimeout(this.__resizeEnd.bind(this),this._resizeData.delta):(this._resizeData.timeout=!1,this.__trigger(wcDocker.EVENT.RESIZE_ENDED))},__moveEnd:function(){new Date-this._moveData.time<this._moveData.delta?setTimeout(this.__moveEnd.bind(this),this._moveData.delta):(this._moveData.timeout=!1,this.__trigger(wcDocker.EVENT.MOVE_ENDED))},__isVisible:function(e){this._isVisible!==e&&(this._isVisible=e,this.__trigger(wcDocker.EVENT.VISIBILITY_CHANGED))},__save:function(){var e={};return e.type="wcPanel",e.panelType=this._type,e.size={x:this._size.x,y:this._size.y},e.customData={},this.__trigger(wcDocker.EVENT.SAVE_LAYOUT,e.customData),e},__restore:function(e,t){e.size&&(this._size.x=e.size.x,this._size.y=e.size.y),this.__trigger(wcDocker.EVENT.RESTORE_LAYOUT,e.customData)},__trigger:function(e,t){if(!e)return!1;if(this._events[e])for(var n=0;n<this._events[e].length;++n)this._events[e][n].call(this,t)},__rect:function(){var e=this.$container.offset(),t=this.$container.width(),n=this.$container.height();return{x:e.left,y:e.top,w:t,h:n}},__container:function(e){return typeof e=="undefined"?this.$container:(this.$container=e,this.$container?this._layout.__container(this.$container):this._layout.__container(null),this.$container)},__destroy:function(){this._panelObject=null,this.off(),this.__container(null),this._parent=null}},wcFrame.prototype={LEFT_TAB_BUFFER:15,docker:function(){var e=this._parent;while(e&&!(e instanceof wcDocker))e=e._parent;return e},pos:function(e,t,n){var r=this.$container.width(),i=this.$container.height();if(typeof e=="undefined")return n?{x:this._pos.x*r,y:this._pos.y*i}:{x:this._pos.x,y:this._pos.y};n?(this._pos.x=e/r,this._pos.y=t/i):(this._pos.x=e,this._pos.y=t)},initSize:function(){var e={x:-1,y:-1};for(var t=0;t<this._panelList.length;++t)e.x<this._panelList[t].initSize().x&&(e.x=this._panelList[t].initSize().x),e.y<this._panelList[t].initSize().y&&(e.y=this._panelList[t].initSize().y);return e.x<0||e.y<0?!1:e},minSize:function(){var e={x:0,y:0};for(var t=0;t<this._panelList.length;++t)e.x=Math.max(e.x,this._panelList[t].minSize().x),e.y=Math.max(e.y,this._panelList[t].minSize().y);return e},maxSize:function(){var e={x:Infinity,y:Infinity};for(var t=0;t<this._panelList.length;++t)e.x=Math.min(e.x,this._panelList[t].maxSize().x),e.y=Math.min(e.y,this._panelList[t].maxSize().y);return e},tabOrientation:function(e){return e!==undefined&&this._tabOrientation!==e&&this.docker()._canOrientTabs&&(this._tabOrientation=e,this.__updateTabs(),this.__updateTabs()),this._tabOrientation},addPanel:function(e,t){var n=this._panelList.indexOf(e);n!==-1&&this._panelList.splice(n,1),typeof t=="undefined"?this._panelList.push(e):this._panelList.splice(t,0,e),this._curTab===-1&&this._panelList.length&&(this.isCollapser()||(this._curTab=0),this._size=this.initSize()),this.__updateTabs()},removePanel:function(e){for(var t=0;t<this._panelList.length;++t)if(this._panelList[t]===e){this.isCollapser()?this._curTab=-1:this._curTab>=t&&this._curTab--,this._panelList[t].__container(null),this._panelList[t]._parent=null,this._panelList.splice(t,1);break}return this._curTab===-1&&!this.collapse()&&this._panelList.length&&(this._curTab=0),this.__updateTabs(),this._panelList.length>0},panel:function(e,t){return typeof e!="undefined"&&(this.isCollapser()&&e===this._curTab&&(this.collapse(),e=-1),e<this._panelList.length&&(this.$tabBar.find('> .wcTabScroller > .wcPanelTab[id="'+this._curTab+'"]').removeClass("wcPanelTabActive"),this.$center.children('.wcPanelTabContent[id="'+this._curTab+'"]').addClass("wcPanelTabContentHidden"),this._curTab!==e&&this.collapse(),this._curTab=e,e>-1&&(this.$tabBar.find('> .wcTabScroller > .wcPanelTab[id="'+e+'"]').addClass("wcPanelTabActive"),this.$center.children('.wcPanelTabContent[id="'+e+'"]').removeClass("wcPanelTabContentHidden"),this.expand()),this.__updateTabs(t))),this._curTab>-1&&this._curTab<this._panelList.length?this._panelList[this._curTab]:this.isCollapser()&&this._panelList.length?this._panelList[0]:!1},isCollapser:function(){return this._parent instanceof wcDrawer},collapse:function(e){return this.isCollapser()?(this._parent.collapse(e),!0):!1},expand:function(){return this.isCollapser()?(this._parent.expand(),!0):!1},isExpanded:function(){if(this.isCollapser())return this._parent.isExpanded()},__init:function(){this.$frame=$('<div class="wcFrame wcWide wcTall">'),this.$title=$('<div class="wcFrameTitle">'),this.$titleBar=$('<div class="wcFrameTitleBar wcFrameTopper">'),this.$tabBar=$('<div class="wcFrameTitleBar">'),this.$tabScroll=$('<div class="wcTabScroller">'),this.$center=$('<div class="wcFrameCenter wcPanelBackground">'),this.$tabLeft=$('<div class="wcFrameButton" title="Scroll tabs to the left."><span class="fa fa-arrow-left"></span>&lt;</div>'),this.$tabRight=$('<div class="wcFrameButton" title="Scroll tabs to the right."><span class="fa fa-arrow-right"></span>&gt;</div>'),this.$close=$('<div class="wcFrameButton" title="Close the currently active panel tab"><div class="fa fa-close"></div>X</div>'),this.$collapse=$('<div class="wcFrameButton" title="Collapse the active panel"><div class="fa fa-download"></div>C</div>'),this.$buttonBar=$('<div class="wcFrameButtonBar">'),this.$tabButtonBar=$('<div class="wcFrameButtonBar">'),this.$tabBar.append(this.$tabScroll),this.$tabBar.append(this.$tabButtonBar),this.$frame.append(this.$buttonBar),this.$buttonBar.append(this.$close),this.$buttonBar.append(this.$collapse),this.$frame.append(this.$center),this._isFloating&&(this.$top=$('<div class="wcFrameEdgeH wcFrameEdge"></div>').css("top","-6px").css("left","0px").css("right","0px"),this.$bottom=$('<div class="wcFrameEdgeH wcFrameEdge"></div>').css("bottom","-6px").css("left","0px").css("right","0px"),this.$left=$('<div class="wcFrameEdgeV wcFrameEdge"></div>').css("left","-6px").css("top","0px").css("bottom","0px"),this.$right=$('<div class="wcFrameEdgeV wcFrameEdge"></div>').css("right","-6px").css("top","0px").css("bottom","0px"),this.$corner1=$('<div class="wcFrameCornerNW wcFrameEdge"></div>').css("top","-6px").css("left","-6px"),this.$corner2=$('<div class="wcFrameCornerNE wcFrameEdge"></div>').css("top","-6px").css("right","-6px"),this.$corner3=$('<div class="wcFrameCornerNW wcFrameEdge"></div>').css("bottom","-6px").css("right","-6px"),this.$corner4=$('<div class="wcFrameCornerNE wcFrameEdge"></div>').css("bottom","-6px").css("left","-6px"),this.$frame.append(this.$top),this.$frame.append(this.$bottom),this.$frame.append(this.$left),this.$frame.append(this.$right),this.$frame.append(this.$corner1),this.$frame.append(this.$corner2),this.$frame.append(this.$corner3),this.$frame.append(this.$corner4)),this.__container(this.$container),this._isFloating&&this.$frame.addClass("wcFloating"),this.$center.scroll(this.__scrolled.bind(this))},__update:function(){var e=this.$container.width(),t=this.$container.height();if(this._isFloating){var n=this._pos.x*e-this._size.x/2,r=this._pos.y*t-this._size.y/2;r<0&&(r=0),n+this._size.x/2<0&&(n=-this._size.x/2),n+this._size.x/2>e&&(n=e-this._size.x/2),r+parseInt(this.$center.css("top"))>t&&(r=t-parseInt(this.$center.css("top"))),this.$frame.css("left",n+"px"),this.$frame.css("top",r+"px"),this.$frame.css("width",this._size.x+"px"),this.$frame.css("height",this._size.y+"px")}if(e!==this._lastSize.x||t!==this._lastSize.y)this._lastSize.x=e,this._lastSize.y=t,this._resizeData.time=new Date,this._resizeData.timeout||(this._resizeData.timeout=!0,setTimeout(this.__resizeEnd.bind(this),this._resizeData.delta));this.__onTabChange()},__resizeEnd:function(){this.__updateTabs(),new Date-this._resizeData.time<this._resizeData.delta?setTimeout(this.__resizeEnd.bind(this),this._resizeData.delta):this._resizeData.timeout=!1},__trigger:function(e,t){for(var n=0;n<this._panelList.length;++n)this._panelList[n].__trigger(e,t)},__save:function(){var e={};e.type="wcFrame",e.floating=this._isFloating,e.isFocus=this.$frame.hasClass("wcFloatingFocus"),e.tabOrientation=this._tabOrientation,e.pos={x:this._pos.x,y:this._pos.y},e.size={x:this._size.x,y:this._size.y},e.tab=this._curTab,e.panels=[];for(var t=0;t<this._panelList.length;++t)e.panels.push(this._panelList[t].__save());return e},__restore:function(e,t){this._isFloating=e.floating,this._tabOrientation=e.tabOrientation||wcDocker.TAB.TOP,this._pos.x=e.pos.x,this._pos.y=e.pos.y,this._size.x=e.size.x,this._size.y=e.size.y,this._curTab=e.tab;for(var n=0;n<e.panels.length;++n){var r=t.__create(e.panels[n],this,this.$center);r.__restore(e.panels[n],t),this._panelList.push(r)}this.__update(),e.isFocus&&this.$frame.addClass("wcFloatingFocus")},__updateTabs:function(e){this.$tabScroll.empty();var t=function(e){switch(this._tabOrientation){case wcDocker.TAB.BOTTOM:return e.offset().left;case wcDocker.TAB.TOP:return e.offset().left;case wcDocker.TAB.LEFT:return e.offset().top;case wcDocker.TAB.RIGHT:return e.offset().top}}.bind(this),n=[],r=[],i=0,s=t(this.$tabScroll),o=this._panelList.length>1||this._isFloating||this.isCollapser(),u=this;this.isCollapser()?this.$tabBar.addClass("wcNotMoveable"):(this.$titleBar.removeClass("wcNotMoveable"),this.$tabBar.removeClass("wcNotMoveable")),this.$center.children(".wcPanelTabContent").each(function(){$(this).addClass("wcPanelTabContentHidden wcPanelTabUnused")}),this._titleVisible=!0,this.$title.text("");for(var a=0;a<this._panelList.length;++a){var f=this._panelList[a],l=null;o&&(l=f.$title,f.$title.attr("id",a),this.$tabScroll.append(f.$title)),f.moveable()||(this.$titleBar.addClass("wcNotMoveable"),this.$tabBar.addClass("wcNotMoveable")),f._titleVisible||(this._titleVisible=!1);var c=this.$center.children('.wcPanelTabContent[id="'+a+'"]');c.length||(c=$('<div class="wcPanelTabContent wcPanelTabContentHidden" id="'+a+'">'),this.$center.append(c)),f.__container(c),f._parent=this;var h=this._curTab===a;f.isVisible()!==h&&n.push({panel:f,isVisible:h}),c.removeClass("wcPanelTabUnused");if(h){l&&l.addClass("wcPanelTabActive"),c.removeClass("wcPanelTabContentHidden"),this.$title.text(f.title());if(f.$icon){var p=f.$icon.clone();this.$title.prepend(p)}}l&&(i=t(l)-s,r.push(i),i+=l.outerWidth())}var d=this.$titleBar,v=0;if(this._titleVisible){this.$frame.parent()||this.$center.css("top","");switch(this._tabOrientation){case wcDocker.TAB.TOP:this.$frame.prepend(this.$tabBar),this.$titleBar.remove(),this.$tabBar.addClass("wcTabTop").removeClass("wcTabLeft wcTabRight wcTabBottom"),o?this.$title.remove():this.$tabBar.prepend(this.$title),d=this.$tabBar,this.$center.css("left",0).css("right",0).css("bottom",0),v=this.$center.width();break;case wcDocker.TAB.BOTTOM:this.$frame.prepend(this.$titleBar),this.$titleBar.append(this.$title);if(o){var m=this.$titleBar.height();this.$frame.append(this.$tabBar),this.$tabBar.addClass("wcTabBottom").removeClass("wcTabTop wcTabLeft wcTabRight"),this.$center.css("left",0).css("right",0).css("bottom",m)}else this.$tabBar.remove();v=this.$center.width();break;case wcDocker.TAB.LEFT:this.$frame.prepend(this.$titleBar),this.$titleBar.append(this.$title);if(o){var m=this.$titleBar.height();this.$frame.append(this.$tabBar),this.$tabBar.addClass("wcTabLeft").removeClass("wcTabTop wcTabRight wcTabBottom"),this.$center.css("left",m).css("right",0).css("bottom",0)}else this.$tabBar.remove();v=this.$center.height();break;case wcDocker.TAB.RIGHT:this.$frame.prepend(this.$titleBar),this.$titleBar.append(this.$title);if(o){var m=this.$titleBar.height();this.$frame.append(this.$tabBar),this.$tabBar.addClass("wcTabRight").removeClass("wcTabTop wcTabLeft wcTabBottom"),this.$center.css("left",0).css("right",m).css("bottom",0)}else this.$tabBar.remove();v=this.$center.height()}o||this.$center.css("left",0).css("right",0).css("bottom",0)}else this.$titleBar.remove(),this.$tabBar.remove(),this.$center.css("top",0).css("left",0).css("right",0).css("bottom",0);this.$center.children(".wcPanelTabUnused").each(function(){$(this).remove()});if(this._titleVisible){var g=this.__onTabChange();if(e)for(var a=0;a<r.length;++a)if(a===this._curTab){var y=r[a],b=i;a+1<r.length&&(b=r[a+1]);var w=-parseInt(this.$tabScroll.css("left")),E=v-g;y<w?(this._tabScrollPos=y-this.LEFT_TAB_BUFFER,this._tabScrollPos<0&&(this._tabScrollPos=0)):b-w>E&&(this._tabScrollPos=b-E+this.LEFT_TAB_BUFFER);break}this._canScrollTabs=!1;if(i>v-g){this._canScrollTabs=this._titleVisible,this._canScrollTabs&&(this.$tabButtonBar.append(this.$tabRight),this.$tabButtonBar.append(this.$tabLeft),g+=this.$tabRight.outerWidth(),g+=this.$tabLeft.outerWidth());var S=i-(v-g)/2;if(this._tabScrollPos>S){var x=this.$tabScroll.children();for(var a=0;a<x.length;++a){var l=$(x[a]);i=t(l)-s;if(i+l.outerWidth()>S){this._tabScrollPos=i-this.LEFT_TAB_BUFFER,this._tabScrollPos<0&&(this._tabScrollPos=0);break}}}}else this._tabScrollPos=0,this.$tabLeft.remove(),this.$tabRight.remove();this.$tabScroll.stop().animate({left:-this._tabScrollPos+"px"},"fast");for(var a=0;a<n.length;++a)n[a].panel.__isVisible(n[a].isVisible)}},__onTabChange:function(){var e=0,t=0,n=this.panel();this.$tabLeft.remove(),this.$tabRight.remove(),this.$close.hide(),this.$collapse.hide();while(this._buttonList.length)this._buttonList.pop().remove();if(n){var r=n.scrollable();this.$center.toggleClass("wcScrollableX",r.x),this.$center.toggleClass("wcScrollableY",r.y),this.$frame.toggleClass("wcOverflowVisible",n.overflowVisible()),this.$center.toggleClass("wcOverflowVisible",n.overflowVisible());if(!this.isCollapser()||this.isExpanded()){n.closeable()&&(this.$close.show(),e+=this.$close.outerWidth());var i=this.docker();if(i.isCollapseEnabled()&&n.moveable()&&n.collapsible()&&!this._isFloating&&!n._isPlaceholder)if(this.isCollapser()){var s=this.$collapse.children("div");s[0].className="fa fa-sign-out";switch(this._parent._position){case wcDocker.DOCK.LEFT:s.addClass("wcCollapseLeft");break;case wcDocker.DOCK.RIGHT:s.addClass("wcCollapseRight");break;case wcDocker.DOCK.BOTTOM:s.addClass("wcCollapseBottom")}s.addClass("wcCollapsed"),this.$collapse.show(),this.$collapse.attr("title","Dock this collapsed panel back into the main layout."),e+=this.$collapse.outerWidth()}else{var o=i.$container;!$.isEmptyObject(i._collapser)&&i._collapser.hasOwnProperty(wcDocker.DOCK.RIGHT)&&(o=i._collapser[wcDocker.DOCK.RIGHT]._parent.$pane[0]);var u=o.offset(),a=this.$container.offset();a.right=(a.left+this.$container.width()-u.left)/o.width(),a.bottom=(a.top+this.$container.height()-u.top)/o.height(),a.top=(a.top-u.top)/o.height(),a.left=(a.left-u.left)/o.width();var f="",l="";a.top>.05&&a.bottom>.95?(f="bottom.",l="wcCollapseBottom"):a.left<=.05?(f="left side.",l="wcCollapseLeft"):a.right>=.95?(f="right side.",l="wcCollapseRight"):a.bottom>.95&&(f="bottom.",l="wcCollapseBottom");if(f){var s=this.$collapse.children("div");s[0].className="fa fa-sign-in",s.addClass(l),s.addClass("wcCollapsible"),this.$collapse.show(),this.$collapse.attr("title","Collapse this panel into the "+f),e+=this.$collapse.outerWidth()}}for(var c=0;c<n._buttonList.length;++c){var h=n._buttonList[c],p=$("<div>"),d=h.className;p.addClass("wcFrameButton"),h.isTogglable&&(p.addClass("wcFrameButtonToggler"),h.isToggled&&(p.addClass("wcFrameButtonToggled"),d=h.toggleClassName||d)),p.attr("title",h.tip),p.data("name",h.name),p.text(h.text),d&&p.prepend($('<div class="'+d+'">')),this._buttonList.push(p),this.$buttonBar.append(p),e+=p.outerWidth()}}this._canScrollTabs&&(this.$tabButtonBar.append(this.$tabRight),this.$tabButtonBar.append(this.$tabLeft),t+=this.$tabRight.outerWidth()+this.$tabLeft.outerWidth());if(this._titleVisible){this.$buttonBar.css("right","");switch(this._tabOrientation){case wcDocker.TAB.RIGHT:this.$buttonBar.css("right",this.$tabBar.height());case wcDocker.TAB.LEFT:this.$tabBar.css("width",this.$center.height()+this.$tabBar.height());break;case wcDocker.TAB.TOP:case wcDocker.TAB.BOTTOM:this.$tabBar.css("width",this.$center.width());break;default:}}n.__update(),this.$center.scrollLeft(n._scroll.x),this.$center.scrollTop(n._scroll.y)}return this.$buttonBar.css("min-width",e).css("width",e),this.$tabButtonBar.css("min-width",t).css("width",t),this._tabOrientation===wcDocker.TAB.TOP?(this.$tabButtonBar.css("right",e),e+t):(this.$tabButtonBar.css("right",0),t)},__scrolled:function(){var e=this.panel();e._scroll.x=this.$center.scrollLeft(),e._scroll.y=this.$center.scrollTop(),e.__trigger(wcDocker.EVENT.SCROLLED)},__focus:function(e){if(e){var t=$('<div class="wcFrameFlasher">');this.$frame.append(t),t.animate({opacity:.25},100).animate({opacity:0},100).animate({opacity:.1},50).animate({opacity:0},50).queue(function(e){t.remove(),e()})}},__move:function(e){var t=this.$container.width(),n=this.$container.height();this._pos.x=(e.x+this._anchorMouse.x)/t,this._pos.y=(e.y+this._anchorMouse.y)/n},__anchorMove:function(e){var t=this.$container.width(),n=this.$container.height();this._anchorMouse.x=this._pos.x*t-e.x,this._anchorMouse.y=this._pos.y*n-e.y},__tabMove:function(e,t){if(e>=0&&e<this._panelList.length&&t>=0&&t<this._panelList.length){var n=this._panelList.splice(e,1);return this._panelList.splice(t,0,n[0]),this._curTab===e&&(this._curTab=t),this.__updateTabs(),this.$tabBar.find('> .wcTabScroller > .wcPanelTab[id="'+t+'"]')[0]}return!1},__checkAnchorDrop:function(e,t,n,r,i){var s=this.panel();return s&&s.moveable()?s.layout().__checkAnchorDrop(e,t&&this._tabOrientation,n,!this._isFloating&&!this.isCollapser()&&r,this.$frame,s.moveable()&&s.title(),i,this.isCollapser()?this._tabOrientation:undefined):!1},__resize:function(e,t){var n=this.$container.width(),r=this.$container.height(),i=this.$container.offset();t.x-=i.left,t.y-=i.top;var s=this.minSize(),o=this.maxSize(),u={x:this._pos.x*n-this._size.x/2,y:this._pos.y*r-this._size.y/2};for(var a=0;a<e.length;++a){switch(e[a]){case"top":this._size.y+=u.y-t.y-2,u.y=t.y+2,this._size.y<s.y&&(u.y+=this._size.y-s.y,this._size.y=s.y),this._size.y>o.y&&(u.y+=this._size.y-o.y,this._size.y=o.y);break;case"bottom":this._size.y=t.y-4-u.y,this._size.y<s.y&&(this._size.y=s.y),this._size.y>o.y&&(this._size.y=o.y);break;case"left":this._size.x+=u.x-t.x-2,u.x=t.x+2,this._size.x<s.x&&(u.x+=this._size.x-s.x,this._size.x=s.x),this._size.x>o.x&&(u.x+=this._size.x-o.x,this._size.x=o.x);break;case"right":this._size.x=t.x-4-u.x,this._size.x<s.x&&(this._size.x=s.x),this._size.x>o.x&&(this._size.x=o.x)}this._pos.x=(u.x+this._size.x/2)/n,this._pos.y=(u.y+this._size.y/2)/r}},__shadow:function(e){if(e)this.$shadower||(this.$shadower=$('<div class="wcFrameShadower">'),this.$frame.append(this.$shadower),this.$shadower.animate({opacity:.5},300));else if(this.$shadower){var t=this;this.$shadower.animate({opacity:0},300).queue(function(e){t.$shadower.remove(),t.$shadower=null,e()})}},__rect:function(){if(this.isCollapser())return this._parent.__rect();var e=this.$frame.offset(),t=this.$frame.width(),n=this.$frame.height();return{x:e.left,y:e.top,w:t,h:n}},__container:function(e){return typeof e=="undefined"?this.$container:(this.$container=e,this.$container?this.$container.append(this.$frame):this.$frame.remove(),this.$container)},__destroy:function(){this._curTab=-1;for(var e=0;e<this._panelList.length;++e)this._panelList[e].__destroy();while(this._panelList.length)this._panelList.pop();this.$modalBlocker&&(this.$modalBlocker.remove(),this.$modalBlocker=null),this.__container(null),this._parent=null}},wcSplitter.prototype={initLayouts:function(){var e=new wcLayout(this.$pane[0],this),t=new wcLayout(this.$pane[1],this);this.pane(0,e),this.pane(1,t)},docker:function(){var e=this._parent;while(e&&!(e instanceof wcDocker))e=e._parent;return e},orientation:function(e){if(typeof e=="undefined")return this._orientation;this._orientation!=e&&(this._orientation=e,this._orientation?this.$bar.removeClass("wcWide").removeClass("wcSplitterBarH").addClass("wcTall").addClass("wcSplitterBarV"):this.$bar.removeClass("wcTall").removeClass("wcSplitterBarV").addClass("wcWide").addClass("wcSplitterBarH"),this.$pane[0].css("top","").css("left","").css("width","").css("height",""),this.$pane[1].css("top","").css("left","").css("width","").css("height",""),this.$bar.css("top","").css("left","").css("width","").css("height",""),this.__update(),this._parent instanceof wcPanel&&this._parent.__trigger(wcDocker.EVENT.UPDATED))},minSize:function(){var e,t;return this._pane[0]&&typeof this._pane[0].minSize=="function"&&(e=this._pane[0].minSize()),this._pane[1]&&typeof this._pane[1].minSize=="function"&&(t=this._pane[1].minSize()),e&&t?(this._orientation?(e.x+=t.x,e.y=Math.max(e.y,t.y)):(e.y+=t.y,e.x=Math.max(e.x,t.x)),e):e?e:t?t:!1},maxSize:function(){var e,t;return this._pane[0]&&typeof this._pane[0].maxSize=="function"&&(e=this._pane[0].maxSize()),this._pane[1]&&typeof this._pane[1].maxSize=="function"&&(t=this._pane[1].maxSize()),e&&t?(this._orientation?(e.x+=t.x,e.y=Math.min(e.y,t.y)):(e.y+=t.y,e.x=Math.min(e.x,t.x)),e):e?e:t?t:!1},pos:function(e){return typeof e!="undefined"&&(this._pos=this._posTarget=e,this.__update(),this._parent instanceof wcPanel&&this._parent.__trigger(wcDocker.EVENT.UPDATED)),this._posTarget},animPos:function(e,t){this._posTarget=e;var n=this;this.$bar.queue(function(e){n._anim&&clearInterval(n._anim),n._anim=setInterval(function(){n._pos>n._posTarget&&(n._pos-=(n._pos-n._posTarget)/5,n._pos<=n._posTarget+.01&&(n._pos=n._posTarget)),n._pos<n._posTarget&&(n._pos+=(n._posTarget-n._pos)/5,n._pos>=n._posTarget-.01&&(n._pos=n._posTarget)),n.__update(),n._pos==n._posTarget&&(t&&t(),e(),clearInterval(n._anim),n._anim=0)},5)}),this.$bar.dequeue()},pane:function(e,t){if(e>=0&&e<2){if(typeof t=="undefined")return this._pane[e];if(t)return this._pane[e]=t,t._parent=this,t.__container(this.$pane[e]),this._pane[0]&&this._pane[1]&&this.__update(),t;this._pane[e]&&(this._pane[e].__container(null),this._pane[e]=!1)}return!1},left:function(e){return this.pane(0,e)},right:function(e){return this.pane(1,e)},top:function(e){return this.pane(0,e)},bottom:function(e){return this.pane(1,e)},scrollable:function(e,t,n){return typeof t!="undefined"&&this.$pane[e].toggleClass("wcScrollableX",t),typeof n!="undefined"&&this.$pane[e].toggleClass("wcScrollableY",n),{x:this.$pane[e].hasClass("wcScrollableX"),y:this.$pane[e].hasClass("wcScrollableY")}},destroy:function(e){var t=this.docker();if(t){var n=this.docker()._splitterList.indexOf(this);n>-1&&this.docker()._splitterList.splice(n,1)}e===undefined||e?this.__destroy():this.__container(null)},__init:function(){this.$pane.push($('<div class="wcLayoutPane wcScrollableX wcScrollableY">')),this.$pane.push($('<div class="wcLayoutPane wcScrollableX wcScrollableY">')),this.$bar=$('<div class="wcSplitterBar">'),this._orientation?this.$bar.addClass("wcTall").addClass("wcSplitterBarV"):this.$bar.addClass("wcWide").addClass("wcSplitterBarH"),this.__container(this.$container);if(this._parent instanceof wcPanel){this._boundEvents.push({event:wcDocker.EVENT.UPDATED,handler:this.__update.bind(this)}),this._boundEvents.push({event:wcDocker.EVENT.CLOSED,handler:this.destroy.bind(this)});for(var e=0;e<this._boundEvents.length;++e)this._parent.on(this._boundEvents[e].event,this._boundEvents[e].handler)}},__update:function(e){var t=this.$container.outerWidth(),n=this.$container.outerHeight(),r=this.__minPos(),i=this.__maxPos();if(this._findBestPos){this._findBestPos=!1;var s,o;this._pane[0]&&typeof this._pane[0].initSize=="function"&&(s=this._pane[0].initSize(),s&&(s.x<0&&(s.x=t/2),s.y<0&&(s.y=n/2))),this._pane[1]&&typeof this._pane[1].initSize=="function"&&(o=this._pane[1].initSize(),o&&(o.x<0&&(o.x=t/2),o.y<0&&(o.y=n/2),o.x=t-o.x,o.y=n-o.y));var u;s&&o?u={x:Math.min(s.x,o.x),y:Math.min(s.y,o.y)}:s?u=s:o&&(u=o),u&&(this._orientation?this._pos=u.x/t:this._pos=u.y/n)}this.$bar.toggleClass("wcSplitterBarStatic",this.__isStatic());if(this._orientation===wcDocker.ORIENTATION.HORIZONTAL){var a=this.$bar.outerWidth()/2,f=parseInt(this.$bar.css("border-top-width"))+parseInt(this.$bar.css("border-bottom-width"));if(e){var l=this._pixelPos-(this.$container.offset().left+parseInt(this.$container.css("border-left-width")))-this.$bar.outerWidth()/2;this._pos=l/(t-this.$bar.outerWidth())}this._pos=Math.min(Math.max(this._pos,0),1);var u=(t-this.$bar.outerWidth())*this._pos+a;r&&(u=Math.max(r.x,u)),i&&(u=Math.min(i.x,u));var c=0,h=0;if(this._parent instanceof wcCollapser){var p=this.docker().$container,d=this._parent.$container;c=d.offset().top-p.offset().top,h=p.offset().top+p.outerHeight()-(d.offset().top+d.outerHeight())}this.$bar.css("left",u-a),this.$bar.css("top",c),this.$bar.css("height",n-f-h),this.$pane[0].css("width",u-a),this.$pane[0].css("left","0px"),this.$pane[0].css("right",""),this.$pane[0].css("top",c),this.$pane[0].css("bottom",h),this.$pane[1].css("left",""),this.$pane[1].css("right","0px"),this.$pane[1].css("width",t-u-a-parseInt(this.$container.css("border-left-width"))*2),this.$pane[1].css("top",c),this.$pane[1].css("bottom",h),this._pixelPos=this.$bar.offset().left+a}else{var a=this.$bar.outerHeight()/2,f=parseInt(this.$bar.css("border-left-width"))+parseInt(this.$bar.css("border-right-width"));if(e){var l=this._pixelPos-(this.$container.offset().top+parseInt(this.$container.css("border-top-width")))-this.$bar.outerHeight()/2;this._pos=l/(n-this.$bar.outerHeight())}this._pos=Math.min(Math.max(this._pos,0),1);var u=(n-this.$bar.outerHeight())*this._pos+a;r&&(u=Math.max(r.y,u)),i&&(u=Math.min(i.y,u));var v=0,m=0;if(this._parent instanceof wcCollapser){var p=this.docker().$container,d=this._parent.$container;v=d.offset().left-p.offset().left,m=p.offset().left+p.outerWidth()-(d.offset().left+d.outerWidth())}this.$bar.css("top",u-a),this.$bar.css("left",v),this.$bar.css("width",t-f-h),this.$pane[0].css("height",u-a),this.$pane[0].css("top","0px"),this.$pane[0].css("bottom",""),this.$pane[0].css("left",v),this.$pane[0].css("right",m),this.$pane[1].css("top",""),this.$pane[1].css("bottom","0px"),this.$pane[1].css("height",n-u-a-parseInt(this.$container.css("border-top-width"))*2),this.$pane[1].css("left",v),this.$pane[1].css("right",m),this._pixelPos=this.$bar.offset().top+a}e===undefined&&(e=!0),this._pane[0]&&this._pane[0].__update(e),this._pane[1]&&this._pane[1].__update(e)},__save:function(){if(this._pane[0]&&this._pane[0]instanceof wcCollapser)return this._pane[1].__save();if(this._pane[1]&&this._pane[1]instanceof wcCollapser)return this._pane[0].__save();var e={};return e.type="wcSplitter",e.horizontal=this._orientation,e.isDrawer=this.$bar.hasClass("wcDrawerSplitterBar"),e.pane0=this._pane[0]?this._pane[0].__save():null,e.pane1=this._pane[1]?this._pane[1].__save():null,e.pos=this._pos,e},__restore:function(e,t){this._pos=e.pos,e.isDrawer&&this.$bar.addClass("wcDrawerSplitterBar"),e.pane0&&(this._pane[0]=t.__create(e.pane0,this,this.$pane[0]),this._pane[0].__restore(e.pane0,t)),e.pane1&&(this._pane[1]=t.__create(e.pane1,this,this.$pane[1]),this._pane[1].__restore(e.pane1,t))},__findBestPos:function(){this._findBestPos=!0},__moveBar:function(e){var t=this.$container.offset();e.x-=t.left,e.y-=t.top;if(this._orientation===wcDocker.ORIENTATION.HORIZONTAL){var n=this.$container.outerWidth()-this.$bar.outerWidth();e.x+=1-parseInt(this.$container.css("border-left-width"))-this.$bar.outerWidth()/2,this.pos(e.x/n)}else{var r=this.$container.outerHeight()-this.$bar.outerHeight();e.y+=1-parseInt(this.$container.css("border-top-width"))-this.$bar.outerHeight()/2,this.pos(e.y/r)}},__minPos:function(){var e=this.$container.outerWidth(),t=this.$container.outerHeight(),n;this._pane[0]&&typeof this._pane[0].minSize=="function"?n=this._pane[0].minSize():n={x:50,y:50};var r;this._pane[1]&&typeof this._pane[1].maxSize=="function"?r=this._pane[1].maxSize():r={x:e,y:t};if(this._orientation===wcDocker.ORIENTATION.HORIZONTAL){var i=this.$bar.outerWidth()/2;n.x+=i,e-=i}else{var i=this.$bar.outerHeight()/2;n.y+=i,t-=i}return r.x=e-Math.min(r.x,e),r.y=t-Math.min(r.y,t),n.x=Math.max(n.x,r.x),n.y=Math.max(n.y,r.y),n},__maxPos:function(){var e=this.$container.outerWidth(),t=this.$container.outerHeight(),n;this._pane[0]&&typeof this._pane[0].maxSize=="function"?n=this._pane[0].maxSize():n={x:e,y:t};var r;this._pane[1]&&typeof this._pane[1].minSize=="function"?r=this._pane[1].minSize():r={x:50,y:50};if(this._orientation===wcDocker.ORIENTATION.HORIZONTAL){var i=this.$bar.outerWidth()/2;n.x+=i,e-=i}else{var i=this.$bar.outerHeight()/2;n.y+=i,t-=i}return r.x=e-r.x,r.y=t-r.y,n.x=Math.min(r.x,n.x),n.y=Math.min(r.y,n.y),n},__isStatic:function(){var e=this._orientation===wcDocker.ORIENTATION.HORIZONTAL?"x":"y";for(var t=0;t<2;++t)if(this._pane[t]&&this._pane[t].minSize&&this._pane[t].maxSize&&this._pane[t].maxSize()[e]-this._pane[t].minSize()[e]===0)return!0;return!1},__container:function(e){return typeof e=="undefined"?this.$container:(this.$container=e,this.$container?(this.$container.append(this.$pane[0]),this.$container.append(this.$pane[1]),this.$container.append(this.$bar)):(this.$pane[0].remove(),this.$pane[1].remove(),this.$bar.remove()),this.$container)},__removeChild:function(e){if(this._pane[0]===e)this._pane[0]=!1;else{if(this._pane[1]!==e)return;this._pane[1]=!1}e&&(e.__container(null),e._parent=null)},__destroy:function(){this._anim&&(clearInterval(this._anim),this._anim=0),this.$bar.clearQueue();while(this._boundEvents.length)this._parent.off(this._boundEvents[0].event,this._boundEvents[0].handler),this._boundEvents.shift();this._pane[0]&&(this._pane[0].__destroy(),this._pane[0]=null),this._pane[1]&&(this._pane[1].__destroy(),this._pane[1]=null),this.__container(null),this._parent=!1}},wcCollapser.prototype={docker:function(){var e=this._parent;while(e&&!(e instanceof wcDocker))e=e._parent;return e},collapse:function(e){this._drawer.collapse()},expand:function(){this._drawer.expand()},isExpanded:function(){return this._drawer.isExpanded()},minSize:function(){return{x:this._size,y:this._size}},maxSize:function(){var e=this._orientation===wcDocker.ORIENTATION.HORIZONTAL?!0:!1;return{x:e?this._size:Infinity,y:e?Infinity:this._size}},__init:function(){this.$frame=$('<div class="wcCollapserFrame">'),this.__container(this.$container);var e=this.docker();this._splitter=new wcSplitter(e.$container,this,this._orientation),this._drawer=new wcDrawer(e.$transition,this._splitter,this._position);switch(this._position){case wcDocker.DOCK.LEFT:this._splitter.pane(0,this._drawer),this._splitter.$pane[1].remove(),this._splitter.$pane[0].addClass("wcDrawer"),this._splitter.pos(0);break;case wcDocker.DOCK.RIGHT:case wcDocker.DOCK.BOTTOM:this._splitter.pane(1,this._drawer),this._splitter.$pane[0].remove(),this._splitter.$pane[1].addClass("wcDrawer"),this._splitter.pos(1)}this._parent.$bar.addClass("wcSplitterHidden")},__update:function(e){this._splitter.__update(),this.__adjustSize()},__adjustSize:function(){this._drawer._frame._panelList.length?this._size=this._drawer._frame.$tabBar.outerHeight():this._size=0},__rect:function(){return this._drawer.__rect()},__save:function(){var e={};return e.size=this._size,e.drawer=this._drawer.__save(),e},__restore:function(e,t){this._size=e.size,this._drawer.__restore(e.drawer,t),this.__adjustSize()},__container:function(e){return typeof e=="undefined"?this.$container:(this.$container=e,this.$container?this.$container.append(this.$frame):this.$frame.remove(),this.$container)},__destroy:function(){this._splitter&&(this._splitter.__destroy(),this._splitter=null,this._frame=null),this.__container(null),this._parent=null}},wcDrawer.prototype={docker:function(){var e=this._parent;while(e&&!(e instanceof wcDocker))e=e._parent;return e},collapse:function(e){if(this._expanded){var t=this._frame.panel();if(t){var n=this._parent.pos();this._position!==wcDocker.DOCK.LEFT&&(n=1-n);var r;this._position===wcDocker.DOCK.BOTTOM?(r=this.docker().$container.height(),t._size.y=n*r):(r=this.docker().$container.width(),t._size.x=n*r)}this._expanded=!1;if(e)switch(this._position){case wcDocker.DOCK.TOP:case wcDocker.DOCK.LEFT:this._parent.pos(0);break;case wcDocker.DOCK.RIGHT:case wcDocker.DOCK.BOTTOM:this._parent.pos(1)}else{this._sliding=!0;var i=this,s=function(){i._sliding=!1,i._parent.__update()};switch(this._position){case wcDocker.DOCK.TOP:case wcDocker.DOCK.LEFT:this._parent.animPos(0,s);break;case wcDocker.DOCK.RIGHT:case wcDocker.DOCK.BOTTOM:this._parent.animPos(1,s)}}}},expand:function(){if(!this._expanded){this._expanded=!0,this._sliding=!0;var e=this._frame.panel();if(e){var t,n;this._position===wcDocker.DOCK.BOTTOM?(t=e._size.y,n=this.docker().$container.height()):(t=e._size.x,n=this.docker().$container.width()),this._position!==wcDocker.DOCK.LEFT&&(t=n-t),t/=n;var r=this;this._parent.animPos(t,function(){r._sliding=!1,r._parent.__update()})}}},isExpanded:function(){return this._expanded},minSize:function(){return this._expanded?this._root&&typeof this._root.minSize=="function"?this._root.minSize():{x:100,y:100}:(this.__adjustCollapsedSize(),{x:this._closeSize,y:this._closeSize})},maxSize:function(){var e=this._orientation===wcDocker.ORIENTATION.HORIZONTAL?!0:!1;return this._expanded||this._sliding?this._root&&typeof this._root.maxSize=="function"?{x:e?this._root.maxSize().x:Infinity,y:e?Infinity:this._root.maxSize().y}:{x:Infinity,y:Infinity}:(this.__adjustCollapsedSize(),{x:e?this._closeSize:Infinity,y:e?Infinity:this._closeSize})},__init:function(){this.$frame=$('<div class="wcCollapserFrame">'),this.__container(this.$container),this._frame=new wcFrame(this.$frame,this,!1),this._frame.tabOrientation(this._position)},__update:function(e){this.__adjustCollapsedSize(),this._frame.__update()},__adjustCollapsedSize:function(){this._frame._panelList.length?(this._closeSize=this._frame.$tabBar.outerHeight(),this._parent.$bar.removeClass("wcSplitterHidden")):(this._closeSize=0,this._parent.$bar.addClass("wcSplitterHidden"))},__rect:function(){var e=this.$frame.offset(),t=this.$frame.width(),n=this.$frame.height(),r=this._frame.panel();return r&&(this._position===wcDocker.DOCK.BOTTOM?(n=r._size.y,t/=3):(t=r._size.x,n/=3)),{x:e.left,y:e.top,w:t,h:n}},__save:function(){var e={};return e.closeSize=this._closeSize,e.frame=this._frame.__save(),e},__restore:function(e,t){this._closeSize=e.closeSize,this._frame.__restore(e.frame,t),this.__adjustCollapsedSize()},__container:function(e){return typeof e=="undefined"?this.$container:(this.$container=e,this.$container?this.$container.append(this.$frame):this.$frame.remove(),this.$container)},__destroy:function(){this._frame&&(this._frame.__destroy(),this._frame=null),this.__container(null),this._parent=null}},wcTabFrame.prototype={LEFT_TAB_BUFFER:15,docker:function(){var e=this._parent;while(e&&!(e instanceof wcDocker))e=e._parent;return e},destroy:function(){this.__destroy()},tabOrientation:function(e){return e!==undefined&&this._tabOrientation!==e&&this.docker()._canOrientTabs&&(this._tabOrientation=e,this.__updateTabs(),this.__updateTabs()),this._tabOrientation},addTab:function(e,t){var n=new wcLayout(".wcDockerTransition",this._parent);return n.name=e,n._scrollable={x:!0,y:!0},n._scroll={x:0,y:0},n._closeable=!1,n._overflowVisible=!1,typeof t=="undefined"?this._layoutList.push(n):this._layoutList.splice(t,0,n),this._curTab===-1&&this._layoutList.length&&(this._curTab=0),this.__updateTabs(),n},removeTab:function(e){if(e>-1&&e<this._layoutList.length){var t=this._layoutList[e].name;return this._layoutList[e].__destroy(),this._layoutList.splice(e,1),this._curTab>=e&&(this._curTab--,this._curTab<0&&(this._curTab=0)),this.__updateTabs(),this._parent.__trigger(wcDocker.EVENT.CUSTOM_TAB_CLOSED,{obj:this,name:t,index:e}),!0}return!1},tab:function(e,t){if(typeof e!="undefined"&&e>-1&&e<this._layoutList.length){this.$tabBar.find('> .wcTabScroller > .wcPanelTab[id="'+this._curTab+'"]').removeClass("wcPanelTabActive"),this.$center.children('.wcPanelTabContent[id="'+this._curTab+'"]').addClass("wcPanelTabContentHidden"),this._curTab=e,this.$tabBar.find('> .wcTabScroller > .wcPanelTab[id="'+e+'"]').addClass("wcPanelTabActive"),this.$center.children('.wcPanelTabContent[id="'+e+'"]').removeClass("wcPanelTabContentHidden"),this.__updateTabs(t);var n=this._layoutList[this._curTab].name;this._parent.__trigger(wcDocker.EVENT.CUSTOM_TAB_CHANGED,{obj:this,name:n,index:e})}return this._curTab},layout:function(e){return e>-1&&e<this._layoutList.length?this._layoutList[e]:!1},moveTab:function(e,t){if(e>=0&&e<this._layoutList.length&&t>=0&&t<this._layoutList.length){var n=this._layoutList.splice(e,1);return this._layoutList.splice(t,0,n[0]),this._curTab===e&&(this._curTab=t),this.__updateTabs(),this.$tabBar.find('> .wcTabScroller > .wcPanelTab[id="'+t+'"]')[0]}return!1},moveable:function(e){return typeof e!="undefined"&&(this._moveable=e),this._moveable},closeable:function(e,t){if(e>-1&&e<this._layoutList.length){var n=this._layoutList[e];return typeof t!="undefined"&&(n._closeable=t),n._closeable}return!1},scrollable:function(e,t,n){if(e>-1&&e<this._layoutList.length){var r=this._layoutList[e],i=!1;return typeof t!="undefined"&&(r._scrollable.x=t,i=!0),typeof n!="undefined"&&(r._scrollable.y=n,i=!0),i&&this.__onTabChange(),{x:r._scrollable.x,y:r._scrollable.y}}return!1},overflowVisible:function(e,t){if(e>-1&&e<this._layoutList.length){var n=this._layoutList[e];return typeof overflow!="undefined"&&(n._overflowVisible=overflow,this.__onTabChange()),n._overflowVisible}return!1},icon:function(e,t){if(e>-1&&e<this._layoutList.length){var n=this._layoutList[e];n.$icon||(n.$icon=$("<div>")),n.$icon.removeClass(),n.$icon.addClass("wcTabIcon "+t)}},faicon:function(e,t){if(e>-1&&e<this._layoutList.length){var n=this._layoutList[e];n.$icon||(n.$icon=$("<div>")),n.$icon.removeClass(),n.$icon.addClass("fa fa-fw fa-"+t)}},__init:function(){this.$frame=$('<div class="wcCustomTab wcWide wcTall">'),this.$tabBar=$('<div class="wcFrameTitleBar wcCustomTabTitle wcWide">'),this.$tabScroll=$('<div class="wcTabScroller">'),this.$center=$('<div class="wcFrameCenter wcPanelBackground">'),this.$tabLeft=$('<div class="wcFrameButton" title="Scroll tabs to the left."><span class="fa fa-arrow-left"></span>&lt;</div>'),this.$tabRight=$('<div class="wcFrameButton" title="Scroll tabs to the right."><span class="fa fa-arrow-right"></span>&gt;</div>'),this.$close=$('<div class="wcFrameButton" title="Close the currently active panel tab"><span class="fa fa-close"></span>X</div>'),this.$buttonBar=$('<div class="wcFrameButtonBar">'),this.$tabBar.append(this.$tabScroll),this.$tabBar.append(this.$buttonBar),this.$buttonBar.append(this.$close),this.$frame.append(this.$center),this.$frame.append(this.$tabBar),this.__container(this.$container),this._boundEvents.push({event:wcDocker.EVENT.UPDATED,handler:this.update.bind(this)}),this._boundEvents.push({event:wcDocker.EVENT.CLOSED,handler:this.destroy.bind(this)});for(var e=0;e<this._boundEvents.length;++e)this._parent.on(this._boundEvents[e].event,this._boundEvents[e].handler);var t=this.docker();t&&t._tabList.push(this)},update:function(){this.__updateTabs()},__updateTabs:function(e){this.$tabScroll.empty();var t=function(e){switch(this._tabOrientation){case wcDocker.TAB.BOTTOM:return e.offset().left;case wcDocker.TAB.TOP:return e.offset().left;case wcDocker.TAB.LEFT:return e.offset().top;case wcDocker.TAB.RIGHT:return e.offset().top}}.bind(this),n=[],r=0,i=t(this.$tabScroll),s=this;this.$center.children(".wcPanelTabContent").each(function(){$(this).addClass("wcPanelTabContentHidden wcPanelTabUnused")});for(var o=0;o<this._layoutList.length;++o){var u=$('<div id="'+o+'" class="wcPanelTab"><div>'+this._layoutList[o].name+"</div></div>");this._moveable&&u.addClass("wcCustomTabMoveable"),this.$tabScroll.append(u),this._layoutList[o].$icon&&u.find("div").prepend(this._layoutList[o].$icon);var a=this.$center.children('.wcPanelTabContent[id="'+o+'"]');a.length||(a=$('<div class="wcPanelTabContent wcPanelTabContentHidden" id="'+o+'">'),this.$center.append(a)),this._layoutList[o].__container(a),this._layoutList[o]._parent=this;var f=this._curTab===o;a.removeClass("wcPanelTabUnused"),f&&(u.addClass("wcPanelTabActive"),a.removeClass("wcPanelTabContentHidden")),r=t(u)-i,n.push(r),r+=u.outerWidth()}var l=0,c=this.$tabBar.height();switch(this._tabOrientation){case wcDocker.TAB.TOP:this.$tabBar.addClass("wcTabTop").removeClass("wcTabLeft wcTabRight wcTabBottom"),this.$center.css("top",c).css("left",0).css("right",0).css("bottom",0),l=this.$center.width();break;case wcDocker.TAB.BOTTOM:this.$tabBar.addClass("wcTabBottom").removeClass("wcTabTop wcTabLeft wcTabRight"),this.$center.css("top",0).css("left",0).css("right",0).css("bottom",c),l=this.$center.width();break;case wcDocker.TAB.LEFT:this.$tabBar.addClass("wcTabLeft").removeClass("wcTabTop wcTabRight wcTabBottom"),this.$center.css("top",0).css("left",c).css("right",0).css("bottom",0),l=this.$center.height();break;case wcDocker.TAB.RIGHT:this.$tabBar.addClass("wcTabRight").removeClass("wcTabTop wcTabLeft wcTabBottom"),this.$center.css("top",0).css("left",0).css("right",c).css("bottom",0),l=this.$center.height()}this.$center.children(".wcPanelTabUnused").each(function(){$(this).remove()});var h=this.__onTabChange();if(e)for(var o=0;o<n.length;++o)if(o===this._curTab){var p=n[o],d=r;o+1<n.length&&(d=n[o+1]);var v=-parseInt(this.$tabScroll.css("left")),m=l-h;p<v?(this._tabScrollPos=p-this.LEFT_TAB_BUFFER,this._tabScrollPos<0&&(this._tabScrollPos=0)):d-v>m&&(this._tabScrollPos=d-m+this.LEFT_TAB_BUFFER);break}this._canScrollTabs=!1;if(r>l-h){this._canScrollTabs=!0,this.$buttonBar.append(this.$tabRight),this.$buttonBar.append(this.$tabLeft),h+=this.$tabRight.outerWidth(),h+=this.$tabLeft.outerWidth();var g=r-(l-h)/2;if(this._tabScrollPos>g){var y=this.$tabScroll.children();for(var o=0;o<y.length;++o){var u=$(y[o]);r=t(u)-i;if(r+u.outerWidth()>g){this._tabScrollPos=r-this.LEFT_TAB_BUFFER,this._tabScrollPos<0&&(this._tabScrollPos=0);break}}}}else this._tabScrollPos=0,this.$tabLeft.remove(),this.$tabRight.remove();this.$tabScroll.stop().animate({left:-this._tabScrollPos+"px"},"fast")},__onTabChange:function(){var e=0,t=this.layout(this._curTab);if(t){this.$center.toggleClass("wcScrollableX",t._scrollable.x),this.$center.toggleClass("wcScrollableY",t._scrollable.y),this.$center.toggleClass("wcOverflowVisible",t._overflowVisible),this.$tabLeft.remove(),this.$tabRight.remove(),t._closeable?(this.$close.show(),e+=this.$close.outerWidth()):this.$close.hide(),this._canScrollTabs&&(this.$tabBar.append(this.$tabRight),this.$tabBar.append(this.$tabLeft),e+=this.$tabRight.outerWidth()+this.$tabLeft.outerWidth());switch(this._tabOrientation){case wcDocker.TAB.RIGHT:case wcDocker.TAB.LEFT:this.$tabBar.css("width",this.$center.height());break;case wcDocker.TAB.TOP:case wcDocker.TAB.BOTTOM:this.$tabBar.css("width",this.$center.width());default:}this.$center.scrollLeft(t._scroll.x),this.$center.scrollTop(t._scroll.y)}return this.$buttonBar.css("min-width",e).css("width",e),e},__scrolled:function(){var e=this.layout(this._curTab);e._scroll.x=this.$center.scrollLeft(),e._scroll.y=this.$center.scrollTop()},__container:function(e){return typeof e=="undefined"?this.$container:(this.$container=e,this.$container?this.$container.append(this.$frame):this.$frame.remove(),this.$container)},__destroy:function(){var e=this.docker();if(e){var t=e._tabList.indexOf(this);t>-1&&e._tabList.splice(t,1)}while(this._boundEvents.length)this._parent.off(this._boundEvents[0].event,this._boundEvents[0].handler),this._boundEvents.shift();this._curTab=-1;for(var n=0;n<this._layoutList.length;++n)this._layoutList[n].__destroy();while(this._layoutList.length)this._layoutList.pop();this.__container(null),this._parent=null}},wcIFrame.prototype={docker:function(){var e=this._panel;while(e&&!(e instanceof wcDocker))e=e._parent;return e},openURL:function(e){this.__clearFrame(),this.$iFrame=$("<iframe>iFrames not supported on your device!</iframe>"),this.$frame.prepend(this.$iFrame),this.__onMoved(),this._window=this.$iFrame[0].contentWindow||this.$iFrame[0],this.__updateFrame(),this._window.location.replace(e),this.$iFrame[0].focus(),this.$iFrame.hover(this.__onHoverEnter.bind(this),this.__onHoverExit.bind(this))},openHTML:function(e){this.__clearFrame(),this.$iFrame=$("<iframe>iFrames not supported on your device!</iframe>"),this.$frame.prepend(this.$iFrame),this.__onMoved(),this._window=this.$iFrame[0].contentWindow||this.$iFrame[0],this.__updateFrame(),this._window.document.open(),this._window.document.write(e),this._window.document.close(),this.$iFrame[0].focus(),this.$iFrame.hover(this.__onHoverEnter.bind(this),this.__onHoverExit.bind(this))},openSRC:function(e){this.__clearFrame(),this.$iFrame=$("<iframe>iFrames not supported on your device!</iframe>"),this.$frame.prepend(this.$iFrame),this.__onMoved(),this._window=this.$iFrame[0].contentWindow||this.$iFrame[0],this.__updateFrame(),this.$iFrame[0].srcdoc=e,this.$iFrame[0].focus(),this.$iFrame.hover(this.__onHoverEnter.bind(this),this.__onHoverExit.bind(this))},show:function(){this.$frame&&this.$frame.removeClass("wcIFrameHidden")},hide:function(){this.$frame&&this.$frame.addClass("wcIFrameHidden")},window:function(){return this._window},destroy:function(){while(this._boundEvents.length)this._panel.off(this._boundEvents[0].event,this._boundEvents[0].handler),this._boundEvents.shift();this.__clearFrame(),this._panel=null,this._layout=null,this.$container=null,this.$frame.remove(),this.$frame=null,this.$focus=null},__init:function(){this.$frame=$('<div class="wcIFrame">'),this.$focus=$('<div class="wcIFrameFocus">'),this._panel.docker().$container.append(this.$frame),this.$frame.append(this.$focus),this._boundEvents.push({event:wcDocker.EVENT.VISIBILITY_CHANGED,handler:this.__onVisibilityChanged.bind(this)}),this._boundEvents.push({event:wcDocker.EVENT.BEGIN_DOCK,handler:this.__onBeginDock.bind(this)}),this._boundEvents.push({event:wcDocker.EVENT.END_DOCK,handler:this.__onEndDock.bind(this)}),this._boundEvents.push({event:wcDocker.EVENT.MOVE_STARTED,handler:this.__onMoveStarted.bind(this)}),this._boundEvents.push({event:wcDocker.EVENT.RESIZE_STARTED,handler:this.__onMoveStarted.bind(this)}),this._boundEvents.push({event:wcDocker.EVENT.MOVE_ENDED,handler:this.__onMoveFinished.bind(this)}),this._boundEvents.push({event:wcDocker.EVENT.RESIZE_ENDED,handler:this.__onMoveFinished.bind(this)}),this._boundEvents.push({event:wcDocker.EVENT.MOVED,handler:this.__onMoved.bind(this)}),this._boundEvents.push({event:wcDocker.EVENT.RESIZED,handler:this.__onMoved.bind(this)}),this._boundEvents.push({event:wcDocker.EVENT.ATTACHED,handler:this.__onAttached.bind(this)}),this._boundEvents.push({event:wcDocker.EVENT.DETACHED,handler:this.__onDetached.bind(this)}),this._boundEvents.push({event:wcDocker.EVENT.GAIN_FOCUS,handler:this.__onGainFocus.bind(this)}),this._boundEvents.push({event:wcDocker.EVENT.LOST_FOCUS,handler:this.__onLostFocus.bind(this)}),this._boundEvents.push({event:wcDocker.EVENT.CLOSED,handler:this.__onClosed.bind(this)});for(var e=0;e<this._boundEvents.length;++e)this._panel.on(this._boundEvents[e].event,this._boundEvents[e].handler);$(window).blur(this.__onBlur.bind(this))},
			__clearFrame:function(){this.$iFrame&&(this.$iFrame[0].srcdoc="",this.$iFrame.remove(),this.$iFrame=null,this._window=null)},
			__updateFrame:function(){this.$frame&&this._panel&&(this.$frame.toggleClass("wcIFrameFloating",!this._isAttached),this._isAttached?this.$frame.removeClass("wcIFrameFloatingFocus"):this.$frame.toggleClass("wcIFrameFloatingFocus",this._hasFocus),this.$frame.toggleClass("wcIFramePanelHidden",!this._panel.isVisible()),this._panel._parent instanceof wcFrame&&this.$frame.toggleClass("wcDrawer",this._panel._parent.isCollapser()))},
			__focusFix:function(){this.$frame.css("left",parseInt(this.$frame.css("left"))+1),this.$frame.css("left",parseInt(this.$frame.css("left"))-1)},
			__onHoverEnter:function(){this._isHovering=!0},__onHoverExit:function(){this._isHovering=!1},
			__onBlur:function(){this._isHovering&&this.docker().__focus(this._panel._parent)},__onVisibilityChanged:function(){this.__updateFrame()},
			__onBeginDock:function(){this.$frame&&(this._isDocking=!0,this.$frame.addClass("wcIFrameMoving"))},
			__onEndDock:function(){this.$frame&&(this._isDocking=!1,this.$frame.removeClass("wcIFrameMoving"),this.__focusFix())},
			__onMoveStarted:function(){this.$frame&&!this._isDocking&&this.$frame.addClass("wcIFrameMoving")},
			__onMoveFinished:function(){this.$frame&&!this._isDocking&&(this.$frame.removeClass("wcIFrameMoving"),this.__focusFix())},
			__onMoved:function(){if(this.$frame&&this._panel){var e=this.docker().$container.offset(),t=this.$container.offset(),n=this.$container.width(),r=this.$container.height();this.$frame.css("top",t.top-e.top),this.$frame.css("left",t.left-e.left),this.$frame.css("width",n),this.$frame.css("height",r)}},
			__onAttached:function(){this._isAttached=!0,this.__updateFrame()},
			__onDetached:function(){this._isAttached=!1,this.__updateFrame()},
			__onGainFocus:function(){this._hasFocus=!0,this.__updateFrame()},
			__onLostFocus:function(){this._hasFocus=!1,this.__updateFrame()},
			__onClosed:function(){this.destroy()}}