#ifndef ICONSELECTIONDIALOG_H
#define ICONSELECTIONDIALOG_H

#include "wx/wx.h"
#include "wx/grid.h"
#include "wx/dir.h"
#include "wx/filename.h"
#include "wx/bitmap.h"
#include "wx/statbmp.h"
#include "wx/sizer.h"
#include "wx/scrolwin.h"
#include "Array.h"

class IconSelectionDialog : public wxDialog
{
public:
        IconSelectionDialog(wxWindow *parent);
        virtual ~IconSelectionDialog();

        int ShowModal();
        wxString GetSelectedIconPath() const { return m_selectedPath; }

//private:
        void LoadIcons();
        void OnIconSelected(wxMouseEvent& event);
        void OnOK(wxCommandEvent& event);
        void OnCancel(wxCommandEvent& event);

        wxScrolledWindow* m_scrolledWindow;
        wxFlexGridSizer* m_iconSizer;
        wxString m_selectedPath;
        wxButton* m_okButton;
        
        struct IconInfo {
            wxString path;
            wxBitmap bitmap;
            wxStaticBitmap* control;
            wxStaticText* label;
            wxPanel* panel;
        };
        
        Array<IconInfo *> m_icons;
        int m_selectedIndex;

        DECLARE_EVENT_TABLE()
};

extern IconSelectionDialog *gIconSelectionDialog;

#endif // ICONSELECTIONDIALOG_H
