#ifndef _ALLOCATOR_H
#define _ALLOCATOR_H

#include "Traindir3.h"

#define USE_ALLOCATOR_POOL 1

struct PoolAllocatorPage {
	PoolAllocatorPage *_next;
	char	    *_base;
	int	    _nextOffset;
	int	    _maxOffset;
};

class PoolAllocator {
public:
	PoolAllocator(int size);
	virtual ~PoolAllocator();

	void	*Allocate();	    // Allocate a new object. All objects are the same size.
        void    Reset();            // Move all pages to the free set.
	void	Release();	    // Release all memory allocated.

	unsigned long GetAllocatedSize() const;

private:
	PoolAllocatorPage *_pages;
        PoolAllocatorPage *_free_pages;
        int     _nAllocatedPages;
        int     _nFreePages;
	int     _objSize;
};

void	*operator new (size_t s, PoolAllocator *p);
void	operator delete (void *obj, PoolAllocator *p);

#define STRING_PAGE_SIZE 4096   // max number of characters in one string page

class StringPool {
public:
        StringPool();
        virtual ~StringPool();

        Char    *Allocate(const Char *str);
        void    Reset();

        Char    **_pages;
        int     _nPages;    // total number of pages currently allocated:  _pages[0.._nPages-1]
        int     _curPage;   // current page with available memory
        int     _pagePos;   // _pages[_curPage][_pagePos] is the next free location in the page
};

extern unsigned long checkMemory();
extern Char    used_memory[];
extern unsigned long incrSize;
#endif // _ALLOCATOR_H
