/*	FindDialog.cpp - Created by Giampiero Caprino

This file is part of Train Director 3

Train Director is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; using exclusively version 2.
It is expressly forbidden the use of higher versions of the GNU
General Public License.

Train Director is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Train Director; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*/

#include <wx/wxprec.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/textctrl.h>
#include <wx/statline.h>

#include "Traindir3.h"
#include "FindDialog.h"

FindDialog::FindDialog(wxWindow *parent)
: wxDialog(parent, 0, wxT("Find"), wxDefaultPosition, wxDefaultSize,
	   wxDEFAULT_DIALOG_STYLE, L("Find Object in Layout"))
{
	wxArrayString   strings;
	wxChar	buff[256];
	wxBoxSizer	    *column = new wxBoxSizer( wxVERTICAL );
	wxBoxSizer	    *row = new wxBoxSizer( wxHORIZONTAL );

	wxStaticText	    *header = new wxStaticText( this, 0, L("&Name"));
	m_name = new wxTextCtrl( this, 0, wxEmptyString, wxDefaultPosition, wxDefaultSize);

	row->Add(header, 35, wxALIGN_LEFT | wxRIGHT, 4);
	row->Add(m_name, 65, wxGROW | wxALIGN_RIGHT | wxLEFT, 6);

	column->Add(row, 1, wxGROW | wxTOP | wxRIGHT | wxLEFT, 10);

	column->Add(CreateButtonSizer(wxOK | wxCANCEL), 0, wxGROW | wxALL, 10);

	SetSizer(column);
	column->Fit(this);
	column->SetSizeHints(this);
}

FindDialog::~FindDialog()
{
}

int	FindDialog::ShowModal()
{
	wxChar	buff[128], buff1[128];
        extern  Coord   highlightCoord;

	Center();
	bool oldIgnore = traindir->m_ignoreTimer;
	traindir->m_ignoreTimer = true;
	m_name->SetFocus();
	int res = wxDialog::ShowModal();
	traindir->m_ignoreTimer = oldIgnore;
        highlightCoord.y = 0;
        if(res != wxID_OK)
	    return wxID_CANCEL;

	buff[sizeof(buff)/sizeof(buff[0]) - 1] = 0;
        wxSnprintf(buff, sizeof(buff)/sizeof(buff[0]), wxT("highlight %s"), m_name->GetValue().c_str());
        trainsim_cmd(buff);
	return wxID_OK;
}

void    show_find_dialog()
{
}
